/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.common.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PEWorkflowDAG {
    private List<Node> nodes;
    private List<Edge> edges;

    public PEWorkflowDAG(@Nonnull List<Node> nodes, @Nullable List<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges == null ? Lists.newLinkedList() : edges;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PEWorkflowDAG)) {
            return false;
        }
        PEWorkflowDAG other = (PEWorkflowDAG)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Node> this$nodes = this.getNodes();
        List<Node> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<Edge> this$edges = this.getEdges();
        List<Edge> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PEWorkflowDAG;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<Edge> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    public String toString() {
        return "PEWorkflowDAG(nodes=" + this.getNodes() + ", edges=" + this.getEdges() + ")";
    }

    public PEWorkflowDAG() {
    }

    public static class Edge {
        private Long from;
        private Long to;

        public Long getFrom() {
            return this.from;
        }

        public Long getTo() {
            return this.to;
        }

        public void setFrom(Long from) {
            this.from = from;
        }

        public void setTo(Long to) {
            this.to = to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$from = this.getFrom();
            Long other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            Long this$to = this.getTo();
            Long other$to = other.getTo();
            return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Edge;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            Long $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            return result;
        }

        public String toString() {
            return "PEWorkflowDAG.Edge(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }

        public Edge() {
        }

        public Edge(Long from, Long to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class Node {
        private Long jobId;
        private String jobName;
        @JsonSerialize(using=ToStringSerializer.class)
        private Long instanceId;
        private Integer status;
        private String result;

        public Node(Long jobId, String jobName) {
            this.jobId = jobId;
            this.jobName = jobName;
        }

        public Long getJobId() {
            return this.jobId;
        }

        public String getJobName() {
            return this.jobName;
        }

        public Long getInstanceId() {
            return this.instanceId;
        }

        public Integer getStatus() {
            return this.status;
        }

        public String getResult() {
            return this.result;
        }

        public void setJobId(Long jobId) {
            this.jobId = jobId;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public void setInstanceId(Long instanceId) {
            this.instanceId = instanceId;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$jobId = this.getJobId();
            Long other$jobId = other.getJobId();
            if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
                return false;
            }
            String this$jobName = this.getJobName();
            String other$jobName = other.getJobName();
            if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
                return false;
            }
            Long this$instanceId = this.getInstanceId();
            Long other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
            String $jobName = this.getJobName();
            result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
            Long $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "PEWorkflowDAG.Node(jobId=" + this.getJobId() + ", jobName=" + this.getJobName() + ", instanceId=" + this.getInstanceId() + ", status=" + this.getStatus() + ", result=" + this.getResult() + ")";
        }

        public Node() {
        }

        public Node(Long jobId, String jobName, Long instanceId, Integer status, String result) {
            this.jobId = jobId;
            this.jobName = jobName;
            this.instanceId = instanceId;
            this.status = status;
            this.result = result;
        }
    }
}

