/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.qqpay;

import cn.hutool.core.util.StrUtil;
import com.ijpay.qqpay.QqPayApiConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QqPayApiConfigKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, QqPayApiConfig> CFG_MAP = new ConcurrentHashMap<String, QqPayApiConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_key_";

    public static QqPayApiConfig putApiConfig(QqPayApiConfig qqPayApiConfig) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, qqPayApiConfig);
        }
        return CFG_MAP.put(qqPayApiConfig.getAppId(), qqPayApiConfig);
    }

    public static QqPayApiConfig setThreadLocalQqPayApiConfig(QqPayApiConfig qqPayApiConfig) {
        if (StrUtil.isNotEmpty((CharSequence)qqPayApiConfig.getAppId())) {
            QqPayApiConfigKit.setThreadLocalAppId(qqPayApiConfig.getAppId());
        }
        return QqPayApiConfigKit.putApiConfig(qqPayApiConfig);
    }

    public static QqPayApiConfig removeApiConfig(QqPayApiConfig qqPayApiConfig) {
        return QqPayApiConfigKit.removeApiConfig(qqPayApiConfig.getAppId());
    }

    public static QqPayApiConfig removeApiConfig(String appId) {
        return CFG_MAP.remove(appId);
    }

    public static void setThreadLocalAppId(String appId) {
        if (StrUtil.isEmpty((CharSequence)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StrUtil.isEmpty((CharSequence)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        return appId;
    }

    public static QqPayApiConfig getQqPayApiConfig() {
        String appId = QqPayApiConfigKit.getAppId();
        return QqPayApiConfigKit.getApiConfig(appId);
    }

    public static QqPayApiConfig getApiConfig(String appId) {
        QqPayApiConfig cfg = CFG_MAP.get(appId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 QqPayApiConfigKit.putApiConfig(qqPayApiConfig) \u5c06 appId \u5bf9\u5e94\u7684 QqPayApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 QqPayApiConfigKit.getQqPayApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }
}

