/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.util;

import com.github.houbb.word.checker.constant.EditOperateEnum;
import java.util.ArrayList;
import java.util.List;

public final class EditDistanceHelper {
    public static int minDistance(String source, String target) {
        int m = source.length();
        int n = target.length();
        int[] prev = new int[n + 1];
        int[] curr = new int[n + 1];
        for (int j = 0; j <= n; ++j) {
            prev[j] = j;
        }
        for (int i = 1; i <= m; ++i) {
            curr[0] = i;
            for (int j = 1; j <= n; ++j) {
                curr[j] = source.charAt(i - 1) == target.charAt(j - 1) ? prev[j - 1] : Math.min(Math.min(prev[j], curr[j - 1]), prev[j - 1]) + 1;
            }
            int[] temp = prev;
            prev = curr;
            curr = temp;
        }
        return prev[n];
    }

    public static List<String> minDistanceList(String source, String target) {
        int i;
        int m = source.length();
        int n = target.length();
        int[][] dp = new int[m + 1][n + 1];
        String[][] operation = new String[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            dp[i][0] = i;
            operation[i][0] = EditOperateEnum.DELETE.getCode();
        }
        for (int j = 0; j <= n; ++j) {
            dp[0][j] = j;
            operation[0][j] = EditOperateEnum.INSERT.getCode();
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                if (source.charAt(i - 1) == target.charAt(j - 1)) {
                    dp[i][j] = dp[i - 1][j - 1];
                    operation[i][j] = "";
                    continue;
                }
                int insert = dp[i][j - 1] + 1;
                int delete = dp[i - 1][j] + 1;
                int replace = dp[i - 1][j - 1] + 1;
                dp[i][j] = Math.min(Math.min(insert, delete), replace);
                operation[i][j] = dp[i][j] == insert ? EditOperateEnum.INSERT.getCode() : (dp[i][j] == delete ? EditOperateEnum.DELETE.getCode() : EditOperateEnum.REPLACE.getCode());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        int i2 = m;
        int j = n;
        StringBuilder currentWord = new StringBuilder(source);
        while (i2 > 0 || j > 0) {
            EditDistanceHelper.addNewWord(result, currentWord.toString());
            if (operation[i2][j].equals("")) {
                --i2;
                --j;
                continue;
            }
            if (operation[i2][j].equals(EditOperateEnum.INSERT.getCode())) {
                currentWord.insert(i2, target.charAt(j - 1));
                --j;
                continue;
            }
            if (operation[i2][j].equals(EditOperateEnum.DELETE.getCode())) {
                currentWord.deleteCharAt(i2 - 1);
                --i2;
                continue;
            }
            if (!operation[i2][j].equals(EditOperateEnum.REPLACE.getCode())) continue;
            currentWord.setCharAt(i2 - 1, target.charAt(j - 1));
            --i2;
            --j;
        }
        EditDistanceHelper.addNewWord(result, currentWord.toString());
        return result;
    }

    private static void addNewWord(List<String> list, String word) {
        if (list.size() > 0 && word.equals(list.get(list.size() - 1))) {
            return;
        }
        list.add(word);
    }
}

