/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.support.format.impl;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.word.checker.support.format.IWordFormat;
import com.github.houbb.word.checker.support.format.impl.AbstractWordFormatInit;
import com.github.houbb.word.checker.support.format.impl.HalfWidthWordFormat;
import com.github.houbb.word.checker.support.format.impl.LowerCaseWordFormat;
import com.github.houbb.word.checker.support.format.impl.NoneWordFormat;

public final class WordFormats {
    private WordFormats() {
    }

    public static IWordFormat defaults() {
        return WordFormats.chains(WordFormats.halfWidth(), WordFormats.lowerCase());
    }

    public static IWordFormat halfWidth() {
        return (IWordFormat)Instances.singleton(HalfWidthWordFormat.class);
    }

    public static IWordFormat lowerCase() {
        return (IWordFormat)Instances.singleton(LowerCaseWordFormat.class);
    }

    public static IWordFormat none() {
        return (IWordFormat)Instances.singleton(NoneWordFormat.class);
    }

    public static IWordFormat chains(final IWordFormat ... formats) {
        if (ArrayUtil.isEmpty((Object[])formats)) {
            return WordFormats.none();
        }
        return new AbstractWordFormatInit(){

            @Override
            protected void init(Pipeline<IWordFormat> pipeline) {
                for (IWordFormat format : formats) {
                    pipeline.addLast((Object)format);
                }
            }
        };
    }
}

