/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.support.data.english;

import com.github.houbb.word.checker.exception.WordCheckRuntimeException;
import com.github.houbb.word.checker.support.data.AbstractWordData;
import com.github.houbb.word.checker.support.data.english.EnglishWordDatas;
import com.github.houbb.word.checker.support.i18n.I18N;
import java.util.HashMap;
import java.util.Map;

class MixedEnglishWordData
extends AbstractWordData {
    private static Map<String, Integer> wordMap = new HashMap<String, Integer>();

    private MixedEnglishWordData() {
    }

    public static MixedEnglishWordData getInstance() {
        return EnWordDataHolder.INSTANCE;
    }

    @Override
    public Map<String, Integer> freqData() {
        return wordMap;
    }

    static {
        try {
            Map<String, Integer> systemWordMap = EnglishWordDatas.system().freqData();
            Map<String, Integer> defineWordMap = EnglishWordDatas.define().freqData();
            wordMap.putAll(systemWordMap);
            wordMap.putAll(defineWordMap);
        }
        catch (Exception e) {
            throw new WordCheckRuntimeException(I18N.get("english_data_file_load_failed"));
        }
    }

    private static class EnWordDataHolder {
        private static final MixedEnglishWordData INSTANCE = new MixedEnglishWordData();

        private EnWordDataHolder() {
        }
    }
}

