/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.support.data.english;

import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.word.checker.exception.WordCheckRuntimeException;
import com.github.houbb.word.checker.support.data.AbstractWordData;
import com.github.houbb.word.checker.support.data.english.InnerWordDataUtil;
import com.github.houbb.word.checker.support.i18n.I18N;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DefineEnglishWordData
extends AbstractWordData {
    private static Map<String, Integer> wordMap = new HashMap<String, Integer>();

    private DefineEnglishWordData() {
    }

    public static DefineEnglishWordData getInstance() {
        return EnWordDataHolder.INSTANCE;
    }

    @Override
    public Map<String, Integer> freqData() {
        return wordMap;
    }

    static {
        try {
            List allLines = StreamUtil.readAllLines((String)"/data/define_word_checker_en.txt");
            InnerWordDataUtil.initWordMap(allLines, wordMap);
        }
        catch (Exception e) {
            throw new WordCheckRuntimeException(I18N.get("english_data_file_load_failed"));
        }
    }

    private static class EnWordDataHolder {
        private static final DefineEnglishWordData INSTANCE = new DefineEnglishWordData();

        private EnWordDataHolder() {
        }
    }
}

