/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.support.data.chinese;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.word.checker.exception.WordCheckRuntimeException;
import com.github.houbb.word.checker.support.data.AbstractWordData;
import java.util.List;
import java.util.Map;

class MixedChineseWordData
extends AbstractWordData {
    private static final Map<String, List<String>> WORD_MAP;

    private MixedChineseWordData() {
    }

    public static MixedChineseWordData getInstance() {
        return ChineseWordDataHolder.INSTANCE;
    }

    @Override
    public Map<String, List<String>> correctData() {
        return WORD_MAP;
    }

    static {
        try {
            List lines = StreamUtil.readAllLines((String)"/data/word_checker_zh.txt");
            List defineLines = StreamUtil.readAllLines((String)"/data/define_word_checker_zh.txt");
            lines.addAll(defineLines);
            WORD_MAP = Guavas.newHashMap((int)lines.size());
            for (String line : lines) {
                if (StringUtil.isEmptyTrim((String)line)) continue;
                String[] strings = line.split(" ");
                WORD_MAP.put(strings[0], StringUtil.splitToList((String)strings[1]));
            }
        }
        catch (Exception e) {
            throw new WordCheckRuntimeException("chinese dict load failed!");
        }
    }

    private static class ChineseWordDataHolder {
        private static final MixedChineseWordData INSTANCE = new MixedChineseWordData();

        private ChineseWordDataHolder() {
        }
    }
}

