/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.core.impl;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.word.checker.core.IWordChecker;
import com.github.houbb.word.checker.core.IWordCheckerContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ZhWordChecker
implements IWordChecker {
    @Override
    public boolean isCorrect(String word, IWordCheckerContext context) {
        Map<String, List<String>> wordData = context.wordData().correctData();
        return !wordData.containsKey(word);
    }

    @Override
    public String correct(String word, IWordCheckerContext context) {
        return this.correctList(word, 1, context).get(0);
    }

    @Override
    public List<String> correctList(String word, int limit, IWordCheckerContext context) {
        Map<String, List<String>> wordData = context.wordData().correctData();
        if (this.isCorrect(word, context)) {
            return Collections.singletonList(word);
        }
        List<String> allList = wordData.get(word);
        int minLimit = Math.min(allList.size(), limit);
        List resultList = Guavas.newArrayList((int)minLimit);
        for (int i = 0; i < minLimit; ++i) {
            resultList.add(allList.get(i));
        }
        return resultList;
    }

    @Override
    public List<String> correctList(String word, IWordCheckerContext context) {
        return this.correctList(word, Integer.MAX_VALUE, context);
    }
}

