/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.core.impl;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.word.checker.core.IWordChecker;
import com.github.houbb.word.checker.core.IWordCheckerContext;
import com.github.houbb.word.checker.exception.WordCheckRuntimeException;
import com.github.houbb.word.checker.support.dto.CandidateDto;
import com.github.houbb.word.checker.support.format.IWordFormat;
import com.github.houbb.word.checker.support.i18n.I18N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EnWordChecker
implements IWordChecker {
    private EnWordChecker() {
    }

    public static EnWordChecker getInstance() {
        return EnWordCheckerHolder.INSTANCE;
    }

    @Override
    public boolean isCorrect(String word, IWordCheckerContext context) {
        String formatWord = this.formatWord(word, context.wordFormat());
        return context.wordData().freqData().containsKey(formatWord);
    }

    @Override
    public final String correct(String word, IWordCheckerContext context) {
        if (this.isCorrect(word, context)) {
            return word;
        }
        return this.correctList(word, 1, context).get(0);
    }

    @Override
    public List<String> correctList(String word, int limit, IWordCheckerContext context) {
        if (limit < 1) {
            throw new WordCheckRuntimeException(I18N.get("english_word_correct_limit_out_of_range"));
        }
        String formatWord = this.formatWord(word, context.wordFormat());
        Map<Integer, Set<String>> editDistanceWordSetMap = this.buildEditDistanceWordSetMap(formatWord, context.maxEditDistance());
        List<CandidateDto> candidateList = this.buildCandidateList(editDistanceWordSetMap, context);
        if (CollectionUtil.isEmpty(candidateList)) {
            return Collections.singletonList(word);
        }
        return this.getCandidateList(candidateList, limit);
    }

    private List<CandidateDto> buildCandidateList(Map<Integer, Set<String>> map, IWordCheckerContext context) {
        Map<String, Integer> wordDataMap = context.wordData().freqData();
        ArrayList<CandidateDto> resultList = new ArrayList<CandidateDto>();
        HashSet<String> allWordSet = new HashSet<String>();
        for (Map.Entry<Integer, Set<String>> entry : map.entrySet()) {
            int distance = entry.getKey();
            Set<String> wordSet = entry.getValue();
            for (String word : wordSet) {
                if (allWordSet.contains(word) || !wordDataMap.containsKey(word)) continue;
                allWordSet.add(word);
                CandidateDto candidateDto = CandidateDto.newInstance().count(wordDataMap.get(word)).editDistance(distance).word(word);
                resultList.add(candidateDto);
            }
        }
        return resultList;
    }

    private Map<Integer, Set<String>> buildEditDistanceWordSetMap(String formatWord, int maxEditDistance) {
        HashMap<Integer, Set<String>> map = new HashMap<Integer, Set<String>>(maxEditDistance + 1);
        HashSet<String> words = new HashSet<String>();
        words.add(formatWord);
        map.put(0, words);
        for (int i = 1; i <= maxEditDistance; ++i) {
            Set preLevelWords = (Set)map.get(i - 1);
            HashSet<String> allWordSet = new HashSet<String>();
            for (String word : preLevelWords) {
                Set<String> otherWordSet = this.edits(word);
                allWordSet.addAll(otherWordSet);
            }
            map.put(i, allWordSet);
        }
        return map;
    }

    private List<String> getCandidateList(List<CandidateDto> candidateDtos, int limit) {
        LinkedList<String> result = new LinkedList<String>();
        Collections.sort(candidateDtos);
        int limitSize = Math.min(limit, candidateDtos.size());
        for (CandidateDto dto : candidateDtos) {
            if (result.size() >= limitSize) break;
            if (result.contains(dto.word())) continue;
            result.add(dto.word());
        }
        return result;
    }

    @Override
    public List<String> correctList(String word, IWordCheckerContext context) {
        return this.correctList(word, Integer.MAX_VALUE, context);
    }

    private Set<String> edits(String word) {
        char c;
        int i;
        HashSet<String> resultSet = new HashSet<String>();
        for (i = 0; i < word.length(); ++i) {
            resultSet.add(word.substring(0, i) + word.substring(i + 1));
        }
        for (i = 0; i < word.length() - 1; ++i) {
            resultSet.add(word.substring(0, i) + word.substring(i + 1, i + 2) + word.substring(i, i + 1) + word.substring(i + 2));
        }
        for (i = 0; i < word.length(); ++i) {
            for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                resultSet.add(word.substring(0, i) + c + word.substring(i + 1));
            }
        }
        for (i = 0; i <= word.length(); ++i) {
            for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                resultSet.add(word.substring(0, i) + c + word.substring(i));
            }
        }
        return resultSet;
    }

    private String formatWord(String original, IWordFormat wordFormat) {
        char[] chars;
        if (StringUtil.isEmptyTrim((String)original)) {
            return original;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : chars = original.toCharArray()) {
            stringBuilder.append(wordFormat.format(c));
        }
        return stringBuilder.toString();
    }

    private static class EnWordCheckerHolder {
        private static final EnWordChecker INSTANCE = new EnWordChecker();

        private EnWordCheckerHolder() {
        }
    }
}

