/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.bs.impl;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.nlp.common.segment.ICommonSegment;
import com.github.houbb.word.checker.bs.IWordCheckerBs;
import com.github.houbb.word.checker.bs.impl.SingleWordCheckerBs;
import com.github.houbb.word.checker.core.IWordChecker;
import com.github.houbb.word.checker.core.impl.EnWordChecker;
import com.github.houbb.word.checker.core.impl.ZhWordChecker;
import com.github.houbb.word.checker.support.data.IWordData;
import com.github.houbb.word.checker.support.data.chinese.ChineseWordDatas;
import com.github.houbb.word.checker.support.data.english.EnglishWordDatas;
import com.github.houbb.word.checker.support.format.IWordFormat;
import com.github.houbb.word.checker.support.format.impl.WordFormats;
import com.github.houbb.word.checker.support.segment.InnerCommonSegments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class WordCheckerBs
implements IWordCheckerBs {
    private ICommonSegment commonSegment = InnerCommonSegments.defaults();
    private IWordData enWordData = EnglishWordDatas.mixed();
    private IWordFormat enWordFormat = WordFormats.defaults();
    private final IWordChecker enWordChecker = EnWordChecker.getInstance();
    private int enMaxEditDistance = 1;
    private final IWordChecker zhWordChecker = (IWordChecker)Instances.singleton(ZhWordChecker.class);
    private IWordData zhWordData = ChineseWordDatas.mixed();
    private int zhMaxEditDistance = 1;
    private IWordFormat zhWordFormat = WordFormats.defaults();
    private SingleWordCheckerBs enWordCheckerBs = null;
    private SingleWordCheckerBs zhWordCheckerBs = null;

    private WordCheckerBs() {
    }

    public static WordCheckerBs newInstance() {
        return new WordCheckerBs();
    }

    public WordCheckerBs init() {
        this.enWordCheckerBs = SingleWordCheckerBs.newInstance().wordFormat(this.enWordFormat).maxEditDistance(this.enMaxEditDistance).wordChecker(this.enWordChecker).wordData(this.enWordData).init();
        this.zhWordCheckerBs = SingleWordCheckerBs.newInstance().wordFormat(this.zhWordFormat).maxEditDistance(this.zhMaxEditDistance).wordChecker(this.zhWordChecker).wordData(this.zhWordData).init();
        return this;
    }

    public WordCheckerBs commonSegment(ICommonSegment commonSegment) {
        this.commonSegment = commonSegment;
        return this;
    }

    public WordCheckerBs enWordData(IWordData enWordData) {
        this.enWordData = enWordData;
        return this;
    }

    public WordCheckerBs zhWordData(IWordData zhWordData) {
        this.zhWordData = zhWordData;
        return this;
    }

    public WordCheckerBs enWordFormat(IWordFormat enWordFormat) {
        this.enWordFormat = enWordFormat;
        return this;
    }

    public WordCheckerBs enMaxEditDistance(int enMaxEditDistance) {
        this.enMaxEditDistance = enMaxEditDistance;
        return this;
    }

    public WordCheckerBs zhMaxEditDistance(int zhMaxEditDistance) {
        this.zhMaxEditDistance = zhMaxEditDistance;
        return this;
    }

    public WordCheckerBs zhWordFormat(IWordFormat zhWordFormat) {
        this.zhWordFormat = zhWordFormat;
        return this;
    }

    @Override
    public boolean isCorrect(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return true;
        }
        List segments = this.commonSegment.segment(text);
        for (String segment : segments) {
            if (!(StringUtil.isEnglish((String)segment) ? !this.enWordCheckerBs.isCorrect(segment) : StringUtil.isChinese((String)segment) && !this.zhWordCheckerBs.isCorrect(segment))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String correct(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List segments = this.commonSegment.segment(text);
        for (String segment : segments) {
            String correct;
            if (StringUtil.isEnglish((String)segment)) {
                correct = this.enWordCheckerBs.correct(segment);
                stringBuilder.append(correct);
                continue;
            }
            if (StringUtil.isChinese((String)segment)) {
                correct = this.zhWordCheckerBs.correct(segment);
                stringBuilder.append(correct);
                continue;
            }
            stringBuilder.append(segment);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> correctList(String text, int limit) {
        Map<String, List<String>> map = this.correctMap(text, limit);
        return this.getList(map);
    }

    @Override
    public List<String> correctList(String text) {
        Map<String, List<String>> map = this.correctMap(text);
        return this.getList(map);
    }

    private List<String> getList(Map<String, List<String>> map) {
        if (MapUtil.isEmpty(map)) {
            return Collections.emptyList();
        }
        Iterator<Map.Entry<String, List<String>>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> correctMap(String text, int limit) {
        if (StringUtil.isEmpty((String)text)) {
            return Collections.emptyMap();
        }
        List segments = this.commonSegment.segment(text);
        HashMap<String, List<String>> maps = new HashMap<String, List<String>>();
        for (String segment : segments) {
            List<String> list = new ArrayList<String>();
            if (StringUtil.isEnglish((String)segment)) {
                list = this.enWordCheckerBs.correctList(segment, limit);
            } else if (StringUtil.isChinese((String)segment)) {
                list = this.zhWordCheckerBs.correctList(segment, limit);
            } else {
                list.add(segment);
            }
            maps.put(segment, list);
        }
        return maps;
    }

    public Map<String, List<String>> correctMap(String text) {
        return this.correctMap(text, Integer.MAX_VALUE);
    }
}

