/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.checker.bs.impl;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.word.checker.bs.IWordCheckerBs;
import com.github.houbb.word.checker.core.IWordChecker;
import com.github.houbb.word.checker.core.IWordCheckerContext;
import com.github.houbb.word.checker.core.impl.EnWordChecker;
import com.github.houbb.word.checker.core.impl.WordCheckerContext;
import com.github.houbb.word.checker.support.data.IWordData;
import com.github.houbb.word.checker.support.data.english.EnglishWordDatas;
import com.github.houbb.word.checker.support.format.IWordFormat;
import com.github.houbb.word.checker.support.format.impl.WordFormats;
import java.util.List;

public final class SingleWordCheckerBs
implements IWordCheckerBs {
    private IWordChecker wordChecker = EnWordChecker.getInstance();
    private IWordData wordData = EnglishWordDatas.mixed();
    private IWordFormat wordFormat = WordFormats.defaults();
    private int maxEditDistance = 1;
    private IWordCheckerContext wordCheckerContext = null;

    public static SingleWordCheckerBs newInstance() {
        return new SingleWordCheckerBs();
    }

    public SingleWordCheckerBs wordData(IWordData wordData) {
        ArgUtil.notNull((Object)wordData, (String)"wordData");
        this.wordData = wordData;
        return this;
    }

    public SingleWordCheckerBs wordFormat(IWordFormat wordFormat) {
        ArgUtil.notNull((Object)wordFormat, (String)"wordFormat");
        this.wordFormat = wordFormat;
        return this;
    }

    public SingleWordCheckerBs maxEditDistance(int maxEditDistance) {
        ArgUtil.gt((String)"maxEditDistance", (long)maxEditDistance, (long)0L);
        this.maxEditDistance = maxEditDistance;
        return this;
    }

    public SingleWordCheckerBs wordChecker(IWordChecker wordChecker) {
        ArgUtil.notNull((Object)wordChecker, (String)"wordChecker");
        this.wordChecker = wordChecker;
        return this;
    }

    public SingleWordCheckerBs init() {
        this.initContext();
        return this;
    }

    @Override
    public boolean isCorrect(String word) {
        return this.wordChecker.isCorrect(word, this.wordCheckerContext);
    }

    @Override
    public String correct(String word) {
        return this.wordChecker.correct(word, this.wordCheckerContext);
    }

    @Override
    public List<String> correctList(String word, int limit) {
        return this.wordChecker.correctList(word, limit, this.wordCheckerContext);
    }

    @Override
    public List<String> correctList(String word) {
        return this.wordChecker.correctList(word, this.wordCheckerContext);
    }

    private void initContext() {
        this.wordCheckerContext = WordCheckerContext.newInstance().maxEditDistance(this.maxEditDistance).wordData(this.wordData).wordFormat(this.wordFormat);
    }
}

