/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.core;

import com.github.houbb.log.integration.adaptors.commons.JakartaCommonsLoggingImpl;
import com.github.houbb.log.integration.adaptors.jdk14.Jdk14LoggingImpl;
import com.github.houbb.log.integration.adaptors.log4j.Log4jImpl;
import com.github.houbb.log.integration.adaptors.log4j2.Log4j2Impl;
import com.github.houbb.log.integration.adaptors.nologging.NoLoggingImpl;
import com.github.houbb.log.integration.adaptors.slf4j.Slf4jImpl;
import com.github.houbb.log.integration.adaptors.stdout.StdOutExImpl;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.exception.LogRuntimeException;
import java.lang.reflect.Constructor;

public final class LogFactory {
    public static final String MARKER = "LOG-INTEGRATION";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> aClass) {
        return LogFactory.getLog(aClass.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Exception t) {
            throw new LogRuntimeException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    @Deprecated
    public static void useCustomLogging(Class<? extends Log> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static void useSlf4jLogging() {
        LogFactory.setImplementation(Slf4jImpl.class);
    }

    public static void useCommonsLogging() {
        LogFactory.setImplementation(JakartaCommonsLoggingImpl.class);
    }

    public static void useLog4JLogging() {
        LogFactory.setImplementation(Log4jImpl.class);
    }

    public static void useLog4J2Logging() {
        LogFactory.setImplementation(Log4j2Impl.class);
    }

    @Deprecated
    public static void useJdkLogging() {
        LogFactory.setImplementation(Jdk14LoggingImpl.class);
    }

    @Deprecated
    public static void useNoLogging() {
        LogFactory.setImplementation(NoLoggingImpl.class);
    }

    public static synchronized void useStdoutExLogging() {
        LogFactory.setImplementation(StdOutExImpl.class);
    }

    private static synchronized void setImplementation(Class<? extends Log> implClass) {
        try {
            if (logConstructor != null) {
                return;
            }
            Constructor<? extends Log> candidate = implClass.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            log.debug("Logging initialized using '" + implClass + "' adapter.");
            logConstructor = candidate;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        LogFactory.useSlf4jLogging();
        LogFactory.useLog4J2Logging();
        LogFactory.useLog4JLogging();
        LogFactory.useCommonsLogging();
        LogFactory.useStdoutExLogging();
    }
}

