/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.slf4j;

import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.ExceptionUtil;
import com.github.houbb.log.integration.util.LogUtil;
import org.slf4j.Logger;

class Slf4jLoggerImpl
implements Log {
    private Logger log;

    public Slf4jLoggerImpl(Logger logger) {
        this.log = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }

    @Override
    public void fatal(String s, Throwable e) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void fatal(String s) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.error(s, e);
    }

    @Override
    public void error(String s) {
        this.log.error(s);
    }

    @Override
    public void debug(String s) {
        this.log.debug(s);
    }

    @Override
    public void trace(String s) {
        this.log.trace(s);
    }

    @Override
    public void warn(String s) {
        this.log.warn(s);
    }

    @Override
    public void info(String s) {
        this.log.info(s);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void fatal(String s, Object ... params) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.log.error(LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.log.error(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void debug(String s, Object ... params) {
        this.log.debug(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void trace(String s, Object ... params) {
        this.log.trace(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void warn(String s, Object ... params) {
        this.log.warn(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void info(String s, Object ... params) {
        this.log.info(LogUtil.getLogInfo(s, params));
    }
}

