/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.support.metadata.util;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class PackageUtil {
    public static String getPackageName(Class clazz) {
        return clazz.getPackage().getName();
    }

    public static String getSlimPackageName(String fullPackageName) {
        if (StringUtil.isEmpty(fullPackageName)) {
            return fullPackageName;
        }
        String[] strings = fullPackageName.split("\\.");
        ArrayList<String> newList = new ArrayList<String>(strings.length);
        for (int i = 0; i < strings.length - 1; ++i) {
            String text = strings[i];
            String firstChar = text.charAt(0) + "";
            newList.add(firstChar);
        }
        newList.add(strings[strings.length - 1]);
        return StringUtil.join(newList, ".");
    }

    public static boolean isSamePackage(String packageName, Class clazz) {
        String targetPackage = PackageUtil.getPackageName(clazz);
        return packageName.equals(targetPackage);
    }

    public static boolean isJavaLangPackage(Class clazz) {
        String packageName = PackageUtil.getPackageName(clazz);
        return "java.lang".equals(packageName);
    }

    public static Set<String> scanPackageClassNameSet(String packageName) {
        ArgUtil.notEmpty(packageName, "packageNames");
        Set<String> classNameSet = Guavas.newHashSet();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    Object[] files;
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    File file = new File(filePath);
                    if (!file.isDirectory() || !ArrayUtil.isNotEmpty(files = file.listFiles())) continue;
                    for (Object entry : files) {
                        PackageUtil.recursiveFile(packageName, (File)entry, classNameSet);
                    }
                    continue;
                }
                if ("jar".equals(protocol)) {
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                    jarEntryEnumeration.nextElement();
                    while (jarEntryEnumeration.hasMoreElements()) {
                        JarEntry jarEntry = jarEntryEnumeration.nextElement();
                        jarEntry.isDirectory();
                        System.out.println("jar " + jarEntry.getName());
                    }
                    continue;
                }
                System.err.println("Not support protocol: " + protocol);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
        return classNameSet;
    }

    private static void recursiveFile(String packageNamePrefix, File file, Set<String> classNameSet) {
        if (file.isFile()) {
            String fileName = file.getName().split("\\.")[0];
            String className = packageNamePrefix + "." + fileName;
            classNameSet.add(className);
        } else if (file.isDirectory()) {
            Object[] files = file.listFiles();
            String dirName = file.getName();
            packageNamePrefix = packageNamePrefix + "." + dirName;
            if (ArrayUtil.isNotEmpty(files)) {
                for (Object fileEntry : files) {
                    PackageUtil.recursiveFile(packageNamePrefix, (File)fileEntry, classNameSet);
                }
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(PackageUtil.getSlimPackageName("com.github.houbb.StringUtil"));
        System.out.println(PackageUtil.getSlimPackageName("StringUtil"));
    }
}

