/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.word.support.data.impl;

import com.github.houbb.chinese.word.model.ChineseWordBean;
import com.github.houbb.chinese.word.support.data.IChineseWordData;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class ChineseWordData
implements IChineseWordData {
    private static final Map<Character, ChineseWordBean> MAP;
    private static final IChineseWordData INSTANCE;

    public static IChineseWordData getInstance() {
        return INSTANCE;
    }

    @Override
    public ChineseWordBean getWordInfo(char c) {
        return MAP.get(Character.valueOf(c));
    }

    @Override
    public Set<Character> getWordSet() {
        return MAP.keySet();
    }

    static {
        INSTANCE = new ChineseWordData();
        List allLines = StreamUtil.readAllLines((String)"/chinese_word_dict_simple.txt");
        MAP = Guavas.newHashMap((int)allLines.size());
        for (String line : allLines) {
            if (StringUtil.isEmptyTrim((String)line)) continue;
            String[] entries = line.split(",");
            ChineseWordBean bean = ChineseWordBean.newInstance();
            bean.setWord(entries[0]);
            bean.setRadicals(entries[1]);
            bean.setStrokes(Integer.parseInt(entries[2]));
            Character character = Character.valueOf(entries[0].charAt(0));
            MAP.put(character, bean);
        }
    }
}

