/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.name.util;

import com.github.houbb.chinese.name.bs.ChineseNameBs;
import com.github.houbb.chinese.name.constant.enums.GenderEnum;
import com.github.houbb.chinese.name.constant.enums.NumEnum;
import com.github.houbb.chinese.name.support.name.family.IFamilyNameStrategy;
import com.github.houbb.chinese.name.support.name.family.impl.FamilyNameStrategies;

public final class ChineseNameHelper {
    private ChineseNameHelper() {
    }

    public static String chineseName() {
        return ChineseNameHelper.chineseName(GenderEnum.random(), FamilyNameStrategies.none());
    }

    public static String chineseName(GenderEnum genderEnum, IFamilyNameStrategy familyNameStrategy) {
        return ChineseNameBs.newInstance().genderEnum(genderEnum).lastNameNum(NumEnum.random()).familyNameStrategy(familyNameStrategy).chineseName();
    }

    public static String lastName(String fullName) {
        return ChineseNameBs.newInstance().lastName(fullName);
    }

    public static String familyName(String fullName) {
        return ChineseNameBs.newInstance().familyName(fullName);
    }
}

