/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.name.util;

import com.github.houbb.chinese.fate.util.ChineseFateHelper;
import com.github.houbb.chinese.name.constant.enums.GenderEnum;
import com.github.houbb.chinese.name.support.data.fate.IChineseFateNameData;
import com.github.houbb.chinese.name.support.data.fate.impl.ChineseFateNameDatas;
import com.github.houbb.chinese.name.support.name.family.IFamilyNameStrategy;
import com.github.houbb.chinese.name.support.name.family.impl.FamilyNameStrategies;
import com.github.houbb.chinese.name.util.ChineseNameHelper;
import com.github.houbb.chinese.name.util.InnerCalendarUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.Collection;
import java.util.List;

public final class ChineseNameFateHelper {
    private ChineseNameFateHelper() {
    }

    public static String fateName() {
        int year = InnerCalendarUtil.getCurrentYear();
        int month = InnerCalendarUtil.getCurrentMonth();
        int day = InnerCalendarUtil.getCurrentDay();
        return ChineseNameFateHelper.fateName(year, month, day);
    }

    public static String fateName(String familyName) {
        int year = InnerCalendarUtil.getCurrentYear();
        int month = InnerCalendarUtil.getCurrentMonth();
        int day = InnerCalendarUtil.getCurrentDay();
        return ChineseNameFateHelper.fateName(year, month, day, familyName, GenderEnum.random());
    }

    public static String fateName(int year, int month, int day) {
        return ChineseNameFateHelper.fateName(year, month, day, "", GenderEnum.random());
    }

    public static String fateName(int year, int month, int day, String familyName, GenderEnum genderEnum) {
        List missList = ChineseFateHelper.wuXingMiss((int)year, (int)month, (int)day);
        IFamilyNameStrategy familyNameStrategy = FamilyNameStrategies.declared(familyName);
        if (CollectionUtil.isEmpty((Collection)missList)) {
            return ChineseNameHelper.chineseName(genderEnum, familyNameStrategy);
        }
        IChineseFateNameData fateNameData = ChineseFateNameDatas.genderSingle(genderEnum);
        StringBuilder lastNameBuffer = new StringBuilder();
        for (String miss : missList) {
            lastNameBuffer.append(fateNameData.name(miss));
            if (lastNameBuffer.length() < 2) continue;
            break;
        }
        return familyName + lastNameBuffer.toString();
    }
}

