/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.name.support.score.impl;

import com.github.houbb.chinese.fate.constant.enums.FateEnum;
import com.github.houbb.chinese.name.model.score.DataSanCaiBean;
import com.github.houbb.chinese.name.support.data.sancai.IChineseNameDataSanCai;
import com.github.houbb.chinese.name.support.data.sancai.impl.ChineseNameDataSanCai;
import com.github.houbb.chinese.name.support.score.IChineseNameScore;
import com.github.houbb.chinese.name.util.ChineseNameHelper;
import com.github.houbb.chinese.word.util.ChineseWordHelper;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import java.util.List;

@ThreadSafe
public class SanCaiChineseNameScore
implements IChineseNameScore {
    private static final IChineseNameDataSanCai SAN_CAI_DATA = new ChineseNameDataSanCai();
    private static final SanCaiChineseNameScore INSTANCE = new SanCaiChineseNameScore();

    public static SanCaiChineseNameScore getInstance() {
        return INSTANCE;
    }

    @Override
    public double score(String fullName) {
        List<DataSanCaiBean> wuGeList = this.buildWuGeList(fullName);
        List<FateEnum> sanCaiList = this.buildSanCaiWuXingList(wuGeList);
        double wuGeScore = this.getWuGeScore(wuGeList);
        double wuXingScore = this.getWuXingScore(sanCaiList);
        return 0.7 * wuGeScore + 0.3 * wuXingScore;
    }

    private List<DataSanCaiBean> buildWuGeList(String fullName) {
        String familyName = ChineseNameHelper.familyName(fullName);
        String lastName = ChineseNameHelper.lastName(fullName);
        int heavenCount = 0;
        heavenCount = familyName.length() == 1 ? this.getCount(familyName.charAt(0)) + 1 : this.getCount(familyName.charAt(0)) + this.getCount(familyName.charAt(1));
        int earthCount = 0;
        earthCount = lastName.length() == 1 ? this.getCount(lastName.charAt(0)) + 1 : this.getCount(lastName.charAt(0)) + this.getCount(lastName.charAt(1));
        int personCount = 0;
        personCount = familyName.length() == 1 ? this.getCount(familyName.charAt(0)) + this.getCount(lastName.charAt(0)) : this.getCount(familyName.charAt(1)) + this.getCount(lastName.charAt(0));
        int totalCount = 0;
        for (char ch : fullName.toCharArray()) {
            totalCount += this.getCount(ch);
        }
        int outCount = 0;
        outCount = familyName.length() == 1 && lastName.length() == 1 ? 2 : (familyName.length() == 1 && lastName.length() == 2 ? totalCount - personCount + 1 : (familyName.length() == 2 && lastName.length() == 1 ? totalCount - personCount + 1 : totalCount - personCount));
        List resultList = Guavas.newArrayList((int)5);
        resultList.add(SAN_CAI_DATA.fierceAndLucky(heavenCount));
        resultList.add(SAN_CAI_DATA.fierceAndLucky(personCount));
        resultList.add(SAN_CAI_DATA.fierceAndLucky(earthCount));
        resultList.add(SAN_CAI_DATA.fierceAndLucky(totalCount));
        resultList.add(SAN_CAI_DATA.fierceAndLucky(outCount));
        return resultList;
    }

    private List<FateEnum> buildSanCaiWuXingList(List<DataSanCaiBean> beans) {
        List resultList = Guavas.newArrayList((int)3);
        for (DataSanCaiBean bean : beans) {
            int count = bean.count();
            FateEnum fateEnum = SAN_CAI_DATA.fiveElements(count);
            resultList.add(fateEnum);
        }
        return resultList;
    }

    private int getCount(char ch) {
        return ChineseWordHelper.getInfo((char)ch).getStrokes();
    }

    private double getWuGeScore(List<DataSanCaiBean> beans) {
        double score = 0.0;
        for (DataSanCaiBean bean : beans) {
            score += bean.score();
        }
        return score / 5.0;
    }

    private double getWuXingScore(List<FateEnum> fateEnumList) {
        double score = 0.0;
        for (int i = 1; i < fateEnumList.size(); ++i) {
            FateEnum fateEnum = fateEnumList.get(i);
            FateEnum preFateEnum = fateEnumList.get(i - 1);
            if (Math.abs(fateEnum.index() - preFateEnum.index()) > 1) continue;
            score += 20.0;
        }
        FateEnum first = fateEnumList.get(0);
        FateEnum last = fateEnumList.get(fateEnumList.size() - 1);
        if (Math.abs(first.index() - last.index()) <= 1) {
            score += 20.0;
        }
        return score;
    }
}

