/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.name.support.gender.impl;

import com.github.houbb.chinese.name.constant.enums.GenderEnum;
import com.github.houbb.chinese.name.model.ChineseNameGenderBean;
import com.github.houbb.chinese.name.support.gender.IChineseNameGenderService;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.tuple.impl.Pair;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class ChineseNameGenderService
implements IChineseNameGenderService {
    private static long boyCharTotal;
    private static long girlCharTotal;
    private static double boyGenderProb;
    private static double girlGenderProb;
    private static Map<Character, Pair<Double, Double>> countMap;

    @Override
    public double calcProb(GenderEnum genderEnum, String lastName) {
        char[] chars;
        double prob = this.getGenderProb(genderEnum);
        for (char c : chars = lastName.toCharArray()) {
            Pair<Double, Double> pair = countMap.get(Character.valueOf(c));
            if (ObjectUtil.isNull(pair)) continue;
            if (GenderEnum.BOY.equals((Object)genderEnum)) {
                prob *= ((Double)pair.getValueOne()).doubleValue();
                continue;
            }
            prob *= ((Double)pair.getValueTwo()).doubleValue();
        }
        return prob;
    }

    private double getGenderProb(GenderEnum genderEnum) {
        if (GenderEnum.BOY.equals((Object)genderEnum)) {
            return boyGenderProb;
        }
        return girlGenderProb;
    }

    static {
        List lines = StreamUtil.readAllLines((String)"/chinese_name_last_name_gender_freq.txt");
        countMap = Guavas.newHashMap((int)lines.size());
        List beanList = Guavas.newArrayList((int)lines.size());
        for (String line : lines) {
            ChineseNameGenderBean bean = ChineseNameGenderBean.of(line);
            boyCharTotal += bean.boyCount();
            girlCharTotal += bean.girlCount();
            beanList.add(bean);
        }
        double boyCharDouble = (double)boyCharTotal * 1.0;
        double girlCharDouble = (double)girlCharTotal * 1.0;
        double charTotalDouble = boyCharDouble + girlCharDouble;
        boyGenderProb = boyCharDouble / charTotalDouble;
        girlGenderProb = girlCharDouble / charTotalDouble;
        for (ChineseNameGenderBean bean : beanList) {
            double boyFreq = (double)bean.boyCount() * 1.0 / boyCharDouble;
            double girlFreq = (double)bean.girlCount() * 1.0 / girlCharDouble;
            Pair pair = Pair.of((Object)boyFreq, (Object)girlFreq);
            countMap.put(Character.valueOf(bean.name()), (Pair<Double, Double>)pair);
        }
    }
}

