/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.name.support.core;

import com.github.houbb.chinese.name.api.IChineseName;
import com.github.houbb.chinese.name.api.IChineseNameContext;
import com.github.houbb.chinese.name.api.IChineseNameGenderProb;
import com.github.houbb.chinese.name.constant.enums.GenderEnum;
import com.github.houbb.chinese.name.constant.enums.NumEnum;
import com.github.houbb.chinese.name.exception.ChineseNameException;
import com.github.houbb.chinese.name.support.core.ChineseNameGenderProb;
import com.github.houbb.chinese.name.support.gender.IChineseNameGenderService;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

@ThreadSafe
public class ChineseName
implements IChineseName {
    @Override
    public String chineseName(IChineseNameContext context) {
        String familyName = context.familyNameStrategy().familyName(context.familyNameData());
        List<String> lastNameList = GenderEnum.BOY.equals((Object)context.genderEnum()) ? context.boyNameData().nameList(context.lastNameNum()) : context.girlNameData().nameList(context.lastNameNum());
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String lastName = lastNameList.get(((Random)random).nextInt(lastNameList.size()));
        return familyName + lastName;
    }

    @Override
    public String lastName(String fullName, IChineseNameContext context) {
        String familyName = this.familyName(fullName, context);
        return fullName.substring(familyName.length());
    }

    @Override
    public String familyName(String fullName, IChineseNameContext context) {
        if (StringUtil.isEmptyTrim((String)fullName) || fullName.length() <= 1) {
            throw new ChineseNameException("Full name's length must be great than 1!");
        }
        List<String> multiFamilyNames = context.familyNameData().nameList(NumEnum.MULTI);
        String firstName = fullName.substring(0, 1);
        if (fullName.length() == 2) {
            return firstName;
        }
        String prefix = fullName.substring(0, 2);
        if (multiFamilyNames.contains(prefix)) {
            return prefix;
        }
        return firstName;
    }

    @Override
    public IChineseNameGenderProb genderProb(String lastName, IChineseNameContext context) {
        if (StringUtil.isEmptyTrim((String)lastName)) {
            throw new ChineseNameException("Last name's length must be great than 0!");
        }
        IChineseNameGenderService genderService = context.genderService();
        double boyProb = genderService.calcProb(GenderEnum.BOY, lastName);
        double girlProb = genderService.calcProb(GenderEnum.GIRL, lastName);
        ChineseNameGenderProb prob = ChineseNameGenderProb.newInstance();
        if (girlProb > boyProb) {
            double resultProb = girlProb / (girlProb + boyProb);
            prob.gender(GenderEnum.GIRL).prob(resultProb);
        } else {
            double resultProb = boyProb / (girlProb + boyProb);
            prob.gender(GenderEnum.BOY).prob(resultProb);
        }
        return prob;
    }
}

