/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.name.bs;

import com.github.houbb.chinese.name.api.IChineseName;
import com.github.houbb.chinese.name.api.IChineseNameContext;
import com.github.houbb.chinese.name.api.IChineseNameGenderProb;
import com.github.houbb.chinese.name.constant.enums.GenderEnum;
import com.github.houbb.chinese.name.constant.enums.NumEnum;
import com.github.houbb.chinese.name.support.core.ChineseName;
import com.github.houbb.chinese.name.support.core.ChineseNameContext;
import com.github.houbb.chinese.name.support.data.IChineseNameData;
import com.github.houbb.chinese.name.support.data.impl.ChineseNameDatas;
import com.github.houbb.chinese.name.support.gender.IChineseNameGenderService;
import com.github.houbb.chinese.name.support.gender.impl.ChineseNameGenderService;
import com.github.houbb.chinese.name.support.name.family.IFamilyNameStrategy;
import com.github.houbb.chinese.name.support.name.family.impl.FamilyNameStrategies;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;

public final class ChineseNameBs {
    private IChineseNameData familyNameData = ChineseNameDatas.family();
    private IChineseNameData boyNameData = ChineseNameDatas.boy();
    private IChineseNameData girlNameData = ChineseNameDatas.girl();
    private GenderEnum genderEnum = GenderEnum.BOY;
    private IFamilyNameStrategy familyNameStrategy = FamilyNameStrategies.none();
    private NumEnum lastNameNum = NumEnum.MULTI;
    private IChineseName chineseName = (IChineseName)Instances.singleton(ChineseName.class);
    private IChineseNameGenderService genderService = (IChineseNameGenderService)Instances.singleton(ChineseNameGenderService.class);

    private ChineseNameBs() {
    }

    public static ChineseNameBs newInstance() {
        return new ChineseNameBs();
    }

    public String chineseName() {
        IChineseNameContext context = this.buildContext();
        return this.chineseName.chineseName(context);
    }

    public String lastName(String fullName) {
        IChineseNameContext context = this.buildContext();
        return this.chineseName.lastName(fullName, context);
    }

    public String familyName(String fullName) {
        IChineseNameContext context = this.buildContext();
        return this.chineseName.familyName(fullName, context);
    }

    public IChineseNameGenderProb genderProb(String lastName) {
        IChineseNameContext context = this.buildContext();
        return this.chineseName.genderProb(lastName, context);
    }

    private IChineseNameContext buildContext() {
        return ChineseNameContext.newInstance().familyNameData(this.familyNameData).familyNameStrategy(this.familyNameStrategy).boyNameData(this.boyNameData).girlNameData(this.girlNameData).genderEnum(this.genderEnum).lastNameNum(this.lastNameNum).genderService(this.genderService);
    }

    public ChineseNameBs familyNameData(IChineseNameData familyNameData) {
        ArgUtil.notNull((Object)familyNameData, (String)"familyNameData");
        this.familyNameData = familyNameData;
        return this;
    }

    public ChineseNameBs boyNameData(IChineseNameData boyNameData) {
        ArgUtil.notNull((Object)boyNameData, (String)"boyNameData");
        this.boyNameData = boyNameData;
        return this;
    }

    public ChineseNameBs girlNameData(IChineseNameData girlNameData) {
        ArgUtil.notNull((Object)girlNameData, (String)"girlNameData");
        this.girlNameData = girlNameData;
        return this;
    }

    public ChineseNameBs genderEnum(GenderEnum genderEnum) {
        ArgUtil.notNull((Object)((Object)genderEnum), (String)"genderEnum");
        this.genderEnum = genderEnum;
        return this;
    }

    public ChineseNameBs familyNameStrategy(IFamilyNameStrategy familyNameStrategy) {
        ArgUtil.notNull((Object)familyNameStrategy, (String)"familyNameStrategy");
        this.familyNameStrategy = familyNameStrategy;
        return this;
    }

    public ChineseNameBs lastNameNum(NumEnum lastNameNum) {
        ArgUtil.notNull((Object)((Object)lastNameNum), (String)"lastNameNum");
        this.lastNameNum = lastNameNum;
        return this;
    }
}

