/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.util;

import com.github.houbb.chars.scan.api.ICharsCore;
import com.github.houbb.chars.scan.api.ICharsReplaceFactory;
import com.github.houbb.chars.scan.api.ICharsReplaceHash;
import com.github.houbb.chars.scan.api.ICharsScanFactory;
import com.github.houbb.chars.scan.bs.CharsScanBs;
import com.github.houbb.chars.scan.support.core.CharsCores;
import com.github.houbb.chars.scan.support.hash.CharsReplaceHashes;
import com.github.houbb.chars.scan.support.replace.CharsReplaces;
import com.github.houbb.chars.scan.support.scan.CharsScans;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import java.util.Set;

public class CharsScanBsHelper {
    public static String scanAndReplace(String text, ICharsScanFactory charScanFactory, ICharsReplaceFactory charsReplaceFactory, ICharsCore charsCore, Set<Character> charsPrefix, ICharsReplaceHash charsReplaceHash) {
        CharsScanBs charsScanBs = CharsScanBs.newInstance().charsScanFactory(charScanFactory).charsReplaceFactory(charsReplaceFactory).charsCore(charsCore).prefixCharSet(charsPrefix).charsReplaceHash(charsReplaceHash).init();
        return charsScanBs.scanAndReplace(text);
    }

    public static String scanAndReplace(String text, ICharsScanFactory charScanFactory, ICharsReplaceFactory charsReplaceFactory, ICharsCore charsCore, Set<Character> charsPrefix) {
        return CharsScanBsHelper.scanAndReplace(text, charScanFactory, charsReplaceFactory, charsCore, charsPrefix, CharsReplaceHashes.defaults());
    }

    public static String scanAndReplace(String text, ICharsScanFactory charScanFactory, ICharsReplaceFactory charsReplaceFactory, ICharsCore charsCore) {
        return CharsScanBsHelper.scanAndReplace(text, charScanFactory, charsReplaceFactory, charsCore, InnerCharUtil.DEFAULT_PREFIX_SET);
    }

    public static String scanAndReplace(String text, ICharsScanFactory charScanFactory, ICharsReplaceFactory charsReplaceFactory) {
        return CharsScanBsHelper.scanAndReplace(text, charScanFactory, charsReplaceFactory, CharsCores.defaults());
    }

    public static String scanAndReplace(String text, ICharsScanFactory charScanFactory) {
        return CharsScanBsHelper.scanAndReplace(text, charScanFactory, CharsReplaces.defaults());
    }

    public static String scanAndReplace(String text) {
        return CharsScanBsHelper.scanAndReplace(text, CharsScans.defaults());
    }
}

