/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractExpandConditionCharScan;

public class EmailExpandConditionCharScan
extends AbstractExpandConditionCharScan {
    @Override
    public int getPriority() {
        return CharsScanTypeEnum.EMAIL.getPriority();
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.EMAIL.getScanType();
    }

    @Override
    protected CharsScanTypeEnum isExpandStartCharCondition(int i, char c, char[] chars, CharsScanContext context) {
        if (c == '@') {
            return CharsScanTypeEnum.EMAIL;
        }
        return null;
    }

    @Override
    protected boolean isLeftExpandMatchCondition(int leftIx, char leftChar, char[] chars, CharsScanContext context) {
        return EmailExpandConditionCharScan.isEmilChar(leftChar);
    }

    @Override
    protected boolean isRightExpandMatchCondition(int rightIx, char rightChar, char[] chars, CharsScanContext context) {
        return EmailExpandConditionCharScan.isEmilChar(rightChar);
    }

    @Override
    protected boolean isLeftBufferMatch(int middleIx, int startIx, char[] chars, CharsScanContext context) {
        int len = middleIx - startIx;
        return len >= 1 && len <= 32;
    }

    @Override
    protected int loopHandleRight(int leftIx, int i, char[] chars, CharsScanContext context, CharsScanTypeEnum scanTypeEnum) {
        StringBuilder buffer = super.getBuffer();
        int rightIx = i + 1;
        int lastPointIx = -1;
        for (rightIx = i + 1; rightIx < chars.length; ++rightIx) {
            char cc = chars[rightIx];
            if ('.' == cc) {
                lastPointIx = rightIx;
            }
            if (!this.isRightExpandMatchCondition(rightIx, cc, chars, context)) break;
            buffer.append(cc);
        }
        if (lastPointIx < 0) {
            return -1;
        }
        int actualRightIx = rightIx - 1;
        if (!this.isRightBufferMatch(i, leftIx, actualRightIx, chars, context)) {
            return -1;
        }
        int differPoint = actualRightIx - lastPointIx;
        if (differPoint < 2) {
            return -1;
        }
        return actualRightIx;
    }

    @Override
    protected boolean isRightBufferMatch(int middleIx, int startIx, int endIx, char[] chars, CharsScanContext context) {
        int len = endIx - middleIx;
        return len >= 3 && len <= 32;
    }

    private static boolean isDigitOrLetter(char c) {
        return Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c);
    }

    private static boolean isEmilChar(char c) {
        return EmailExpandConditionCharScan.isDigitOrLetter(c) || '_' == c || '-' == c || c == '.';
    }
}

