/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.core;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.api.ICharsScan;
import com.github.houbb.chars.scan.support.core.CharsCoreThreadLocal;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CharsCoreConcurrency
extends CharsCoreThreadLocal {
    private final ExecutorService EXECUTOR_SERVICE;

    public CharsCoreConcurrency(int threadSize) {
        this.EXECUTOR_SERVICE = Executors.newFixedThreadPool(threadSize);
    }

    public CharsCoreConcurrency() {
        this(10);
    }

    @Override
    protected List<CharsScanMatchItem> doScan(final char[] chars, List<ICharsScan> charsScanList, final CharsScanContext context) {
        final CopyOnWriteArrayList<CharsScanMatchItem> resultList = new CopyOnWriteArrayList<CharsScanMatchItem>();
        try {
            int scanSize = charsScanList.size();
            if (scanSize > 1) {
                final CountDownLatch countDownLatch = new CountDownLatch(scanSize);
                for (final ICharsScan charsScan : charsScanList) {
                    this.EXECUTOR_SERVICE.execute(new Runnable(){

                        @Override
                        public void run() {
                            CharsCoreConcurrency.this.scanTask(chars, charsScan, context, resultList);
                            countDownLatch.countDown();
                        }
                    });
                }
                countDownLatch.await();
            } else {
                this.scanTask(chars, (ICharsScan)CollectionUtil.getFirst(charsScanList), context, resultList);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return resultList;
    }

    private void scanTask(char[] chars, ICharsScan charsScan, CharsScanContext context, List<CharsScanMatchItem> resultList) {
        for (int i = 0; i < chars.length; ++i) {
            char currentChar = chars[i];
            charsScan.scan(i, currentChar, chars, context);
        }
        List<CharsScanMatchItem> itemList = charsScan.getMatchList();
        if (CollectionUtil.isNotEmpty(itemList)) {
            resultList.addAll(itemList);
        }
    }
}

