/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.aop.core.proxy;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.proxy.IProxy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

@ThreadSafe
public class DynamicProxy
implements InvocationHandler,
IProxy {
    private final Object target;
    private final MethodInterceptor methodInterceptor;

    public DynamicProxy(Object target, MethodInterceptor methodInterceptor) {
        this.target = target;
        this.methodInterceptor = methodInterceptor;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        try {
            MethodInvocation methodInvocation = new MethodInvocation(){

                public Method getMethod() {
                    return method;
                }

                public Object[] getArguments() {
                    return args;
                }

                public Object proceed() throws Throwable {
                    return method.invoke(DynamicProxy.this.target, args);
                }

                public Object getThis() {
                    return DynamicProxy.this.target;
                }

                public AccessibleObject getStaticPart() {
                    return null;
                }
            };
            return this.methodInterceptor.invoke(methodInvocation);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public Object proxy() {
        DynamicProxy handler = new DynamicProxy(this.target, this.methodInterceptor);
        return Proxy.newProxyInstance(handler.getClass().getClassLoader(), this.target.getClass().getInterfaces(), (InvocationHandler)handler);
    }
}

