/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.aop.core.proxy;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.proxy.IProxy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.aopalliance.intercept.MethodInvocation;

@ThreadSafe
public class CglibProxy
implements IProxy,
MethodInterceptor {
    private final Object target;
    private final org.aopalliance.intercept.MethodInterceptor methodInterceptor;

    public CglibProxy(Object target, org.aopalliance.intercept.MethodInterceptor methodInterceptor) {
        this.target = target;
        this.methodInterceptor = methodInterceptor;
    }

    public Object intercept(Object o, final Method method, final Object[] objects, MethodProxy methodProxy) throws Throwable {
        try {
            MethodInvocation methodInvocation = new MethodInvocation(){

                public Method getMethod() {
                    return method;
                }

                public Object[] getArguments() {
                    return objects;
                }

                public Object proceed() throws Throwable {
                    return method.invoke(CglibProxy.this.target, objects);
                }

                public Object getThis() {
                    return CglibProxy.this.target;
                }

                public AccessibleObject getStaticPart() {
                    return null;
                }
            };
            return this.methodInterceptor.invoke(methodInvocation);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public Object proxy() {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(this.target.getClass());
        enhancer.setCallback((Callback)this);
        return enhancer.create();
    }
}

