/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.LUDecomposition;
import smile.math.matrix.Matrix;
import smile.math.matrix.MatrixMultiplication;
import smile.math.matrix.QRDecomposition;

public interface DenseMatrix
extends Matrix,
MatrixMultiplication<DenseMatrix, DenseMatrix> {
    public double set(int var1, int var2, double var3);

    default public double update(int i, int j, double x) {
        return this.set(i, j, x);
    }

    @Override
    public DenseMatrix transpose();

    default public DenseMatrix inverse() {
        return this.inverse(false);
    }

    default public DenseMatrix inverse(boolean inPlace) {
        DenseMatrix a;
        DenseMatrix denseMatrix = a = inPlace ? this : this.copy();
        if (this.nrows() == this.ncols()) {
            LUDecomposition lu = new LUDecomposition(a);
            return lu.inverse();
        }
        QRDecomposition qr = new QRDecomposition(a);
        return qr.inverse();
    }

    public DenseMatrix copy();

    @Override
    public DenseMatrix ata();

    @Override
    public DenseMatrix aat();

    public double add(int var1, int var2, double var3);

    public double sub(int var1, int var2, double var3);

    public double mul(int var1, int var2, double var3);

    public double div(int var1, int var2, double var3);

    default public DenseMatrix add(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) + b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix add(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.add(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix sub(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) - b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix sub(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.sub(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix mul(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) * b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix mul(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mul(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix div(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) / b.get(i, j));
            }
        }
        return c;
    }

    default public DenseMatrix div(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.div(i, j, b.get(i, j));
            }
        }
        return this;
    }

    default public DenseMatrix add(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) + x);
            }
        }
        return c;
    }

    default public DenseMatrix add(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.add(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix sub(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) - x);
            }
        }
        return c;
    }

    default public DenseMatrix sub(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.sub(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix mul(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) * x);
            }
        }
        return c;
    }

    default public DenseMatrix mul(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mul(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix div(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) / x);
            }
        }
        return c;
    }

    default public DenseMatrix div(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.div(i, j, x);
            }
        }
        return this;
    }

    default public DenseMatrix replaceNaN(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!Double.isNaN(this.get(i, j))) continue;
                this.set(i, j, x);
            }
        }
        return this;
    }

    default public double sum() {
        int m = this.nrows();
        int n = this.ncols();
        double s = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                s += this.get(i, j);
            }
        }
        return s;
    }

    default public double[][] array() {
        double[][] V = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                V[i][j] = this.get(i, j);
            }
        }
        return V;
    }

    default public String toString(boolean full) {
        StringBuilder sb = new StringBuilder();
        int fields = 7;
        int m = Math.min(7, this.nrows());
        int n = Math.min(7, this.ncols());
        String newline = n < this.ncols() ? "...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format("%8.4f  ", this.get(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrows()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }
}

