/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.io.Serializable;
import java.util.Iterator;
import smile.math.SparseArray;
import smile.math.distance.Metric;

public class SparseMinkowskiDistance
implements Metric<SparseArray>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int p;
    private double[] weight = null;

    public SparseMinkowskiDistance(int p) {
        if (p <= 0) {
            throw new IllegalArgumentException(String.format("The order p has to be larger than 0: p = d", p));
        }
        this.p = p;
    }

    public SparseMinkowskiDistance(int p, double[] weight) {
        if (p <= 0) {
            throw new IllegalArgumentException(String.format("The order p has to be larger than 0: p = d", p));
        }
        for (int i = 0; i < weight.length; ++i) {
            if (!(weight[i] < 0.0)) continue;
            throw new IllegalArgumentException(String.format("Weight has to be nonnegative: %f", weight[i]));
        }
        this.p = p;
        this.weight = weight;
    }

    public String toString() {
        return String.format("Minkowski distance (p = %d)", this.p);
    }

    @Override
    public double d(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        double dist = 0.0;
        if (this.weight == null) {
            double d;
            while (a != null && b != null) {
                if (a.i < b.i) {
                    d = a.x;
                    dist += Math.pow(d, this.p);
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.i > b.i) {
                    d = b.x;
                    dist += Math.pow(d, this.p);
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                d = a.x - b.x;
                dist += Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                d = a.x;
                dist += Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                d = b.x;
                dist += Math.pow(d, this.p);
                b = iterY.hasNext() ? iterY.next() : null;
            }
        } else {
            double d;
            while (a != null && b != null) {
                if (a.i < b.i) {
                    d = a.x;
                    dist += this.weight[a.i] * Math.pow(d, this.p);
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.i > b.i) {
                    d = b.x;
                    dist += this.weight[b.i] * Math.pow(d, this.p);
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                d = a.x - b.x;
                dist += this.weight[a.i] * Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                d = a.x;
                dist += this.weight[a.i] * Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                d = b.x;
                dist += this.weight[b.i] * Math.pow(d, this.p);
                b = iterY.hasNext() ? iterY.next() : null;
            }
        }
        return Math.pow(dist, 1.0 / (double)this.p);
    }
}

