/*
 * Decompiled with CFR 0.152.
 */
package com.github.gxhunter.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.gxhunter.enums.IResponseCode;
import com.github.gxhunter.enums.ResultEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Result<T> {
    private long status;
    private String message;
    T data;

    public Result() {
    }

    private Result(T data, String message, long status) {
        this.data = data;
        this.message = message;
        this.status = status;
    }

    public boolean isSuccess() {
        return this.status == ResultEnum.SUCCESS.getCode();
    }

    public static <T> Result<T> success(T data, String message) {
        return new Result<T>(data, message, ResultEnum.SUCCESS.getCode());
    }

    public static <T> Result<T> success(T data) {
        return Result.success(data, null);
    }

    public static <T> Result<T> success() {
        return Result.success(null);
    }

    public static <T> Result<T> successMsg(String message) {
        return Result.success(null, message);
    }

    public static <T> Result<T> failed(T data, String message) {
        return new Result<T>(data, message, ResultEnum.DEFAULT_ERROR.getCode());
    }

    public static <T> Result<T> failed(T data, IResponseCode errorCode) {
        return new Result<T>(data, errorCode.getMsg(), errorCode.getCode());
    }

    public static <T> Result<T> failed(String message) {
        return Result.failed(null, message);
    }

    public static <T> Result<T> failed() {
        return Result.failed((String)null);
    }

    public static <T> Result<T> failed(IResponseCode resultEnum) {
        return new Result<Object>(null, resultEnum.getMsg(), resultEnum.getCode());
    }

    public long getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setStatus(long status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $status = this.getStatus();
        result = result * 59 + (int)($status >>> 32 ^ $status);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(status=" + this.getStatus() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

