/*
 * Decompiled with CFR 0.152.
 */
package com.github.gxhunter.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.web.multipart.MultipartFile;

public class SftpTools
implements AutoCloseable {
    private Session session;
    private Channel channel;
    private ChannelSftp chnSftp;

    public void connect(String host, int port, String username, String password) throws JSchException {
        JSch jsch = new JSch();
        this.session = jsch.getSession(username, host, port);
        this.session.setPassword(password);
        Properties sshConfig = new Properties();
        sshConfig.put("StrictHostKeyChecking", "no");
        this.session.setConfig(sshConfig);
        this.session.connect();
        this.channel = this.session.openChannel("sftp");
        this.channel.connect();
        this.chnSftp = (ChannelSftp)this.channel;
    }

    public void cd(String sftpPath) throws SftpException {
        this.chnSftp.cd(sftpPath);
    }

    public String pwd() throws SftpException {
        return this.chnSftp.pwd();
    }

    public boolean isDirExist(String directory) throws SftpException {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = this.chnSftp.lstat(directory);
            isDirExistFlag = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if ("no such file".equals(e.getMessage().toLowerCase())) {
                isDirExistFlag = false;
            }
            return isDirExistFlag;
        }
    }

    public InputStream getFile(String sftpFilePath) throws SftpException {
        if (this.isFileExist(sftpFilePath)) {
            return this.chnSftp.get(sftpFilePath);
        }
        return null;
    }

    public InputStream getInputStreamFile(String sftpFilePath) throws SftpException {
        return this.getFile(sftpFilePath);
    }

    public ByteArrayInputStream getByteArrayInputStreamFile(String sftpFilePath) throws SftpException, IOException {
        if (this.isFileExist(sftpFilePath)) {
            byte[] srcFtpFileByte = this.inputStreamToByte(this.getFile(sftpFilePath));
            return new ByteArrayInputStream(srcFtpFileByte);
        }
        return null;
    }

    public String delFile(String sftpFilePath) throws SftpException {
        String retInfo = "";
        if (this.isFileExist(sftpFilePath)) {
            this.chnSftp.rm(sftpFilePath);
            retInfo = "\u6587\u4ef6\u5df2\u88ab\u5220\u9664";
        } else {
            retInfo = "\u6587\u4ef6\u4e0d\u5b58\u5728";
        }
        return retInfo;
    }

    public String moveFile(String srcSftpFilePath, String distSftpFilePath) throws SftpException, IOException {
        String retInfo = "";
        boolean fileExist = this.isFileExist(srcSftpFilePath);
        boolean dirExist = this.isDirExist(distSftpFilePath);
        if (!fileExist) {
            return "0:file not exist !";
        }
        if (!dirExist) {
            this.createDir(distSftpFilePath);
            dirExist = true;
        }
        String fileName = srcSftpFilePath.substring(srcSftpFilePath.lastIndexOf("/"), srcSftpFilePath.length());
        ByteArrayInputStream srcFtpFileStreams = this.getByteArrayInputStreamFile(srcSftpFilePath);
        this.chnSftp.put((InputStream)srcFtpFileStreams, distSftpFilePath + fileName);
        this.chnSftp.rm(srcSftpFilePath);
        retInfo = "1:move success!";
        return retInfo;
    }

    public String copyFile(String srcSftpFilePath, String distSftpFilePath) throws SftpException, IOException {
        String retInfo = "";
        boolean fileExist = this.isFileExist(srcSftpFilePath);
        boolean dirExist = this.isDirExist(distSftpFilePath);
        if (!fileExist) {
            return "0:file not exist !";
        }
        if (!dirExist) {
            this.createDir(distSftpFilePath);
            dirExist = true;
        }
        String fileName = srcSftpFilePath.substring(srcSftpFilePath.lastIndexOf("/"), srcSftpFilePath.length());
        ByteArrayInputStream srcFtpFileStreams = this.getByteArrayInputStreamFile(srcSftpFilePath);
        this.chnSftp.put((InputStream)srcFtpFileStreams, distSftpFilePath + fileName);
        retInfo = "1:copy file success!";
        return retInfo;
    }

    public String createDir(String sftpDirPath) throws SftpException {
        String[] pathArry;
        this.cd("/");
        if (this.isDirExist(sftpDirPath)) {
            return "0:dir is exist !";
        }
        for (String path : pathArry = sftpDirPath.split("/")) {
            if ("".equals(path)) continue;
            if (this.isDirExist(path)) {
                this.cd(path);
                continue;
            }
            this.chnSftp.mkdir(path);
            this.chnSftp.cd(path);
        }
        this.cd("/");
        return "1:\u521b\u5efa\u76ee\u5f55\u6210\u529f";
    }

    public boolean isFileExist(String srcSftpFilePath) throws SftpException {
        boolean isExitFlag = false;
        if (this.getFileSize(srcSftpFilePath) >= 0L) {
            isExitFlag = true;
        }
        return isExitFlag;
    }

    public long getFileSize(String srcSftpFilePath) throws SftpException {
        long fileSize;
        block2: {
            fileSize = 0L;
            try {
                SftpATTRS sftpATTRS = this.chnSftp.lstat(srcSftpFilePath);
                fileSize = sftpATTRS.getSize();
            }
            catch (Exception e) {
                fileSize = -1L;
                if (!"no such file".equals(e.getMessage().toLowerCase())) break block2;
                fileSize = -2L;
            }
        }
        return fileSize;
    }

    @Override
    public void close() {
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    public byte[] inputStreamToByte(InputStream iStrm) throws IOException {
        byte[] imgdata = null;
        try (ByteArrayOutputStream bytestream = new ByteArrayOutputStream();){
            int ch;
            while ((ch = iStrm.read()) != -1) {
                bytestream.write(ch);
            }
            imgdata = bytestream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imgdata;
    }

    /*
     * Exception decompiling
     */
    public static String uploadMultipartFile(String host, int port, String username, String password, String path, String fileName, MultipartFile multipartFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExistDir(String host, int port, String username, String password, String path) {
        try (SftpTools stpTool = new SftpTools();){
            stpTool.connect(host, port, username, password);
            boolean bl = stpTool.isDirExist(path);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

