/*
 * Decompiled with CFR 0.152.
 */
package com.github.gxhunter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.gxhunter.util.StringUtils;

public class JsonUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> String toJSON(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> String toJSONPretty(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(String str, Class<T> clazz) {
        if (StringUtils.isEmpty((String)str) || clazz == null) {
            return null;
        }
        try {
            return (T)(clazz.equals(String.class) ? str : objectMapper.readValue(str, clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(String str, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((String)str) || typeReference == null) {
            return null;
        }
        try {
            return (T)(typeReference.getType().equals(String.class) ? str : objectMapper.readValue(str, typeReference));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(String str, Class<?> collectionClass, Class<?> ... elementClasses) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
        try {
            return (T)objectMapper.readValue(str, javaType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

