/*
 * Decompiled with CFR 0.152.
 */
package com.github.gxhunter.exception;

import com.github.gxhunter.enums.ResultEnum;
import com.github.gxhunter.exception.ApiException;
import com.github.gxhunter.vo.Result;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@ConditionalOnClass(value={RestControllerAdvice.class})
@ConditionalOnMissingBean(value={ExceptionResolver.class})
@ConditionalOnWebApplication
public class ExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(ExceptionResolver.class);

    @ExceptionHandler(value={ApiException.class})
    public Object handServerException(ApiException exception) {
        if (exception.getErrorCode() != null) {
            return Result.failed(exception.getErrorCode());
        }
        return Result.failed(exception.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object resolveMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        List objectErrors = ex.getBindingResult().getAllErrors();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)objectErrors)) {
            for (ObjectError objectError : objectErrors) {
                String field = ((FieldError)objectError).getField();
                String message = objectError.getDefaultMessage();
                resultMap.put(field, message);
            }
            return Result.failed(resultMap, ResultEnum.METHOD_ARGUMENT_VALID_FAIL);
        }
        return Result.failed(ResultEnum.METHOD_ARGUMENT_VALID_FAIL);
    }

    @ExceptionHandler(value={Exception.class})
    public Object exceptionHandle(Exception e) {
        log.error("\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        return Result.failed(ResultEnum.UNKNOW_ERROR);
    }
}

