/*
 * Decompiled with CFR 0.152.
 */
package com.github.gxhunter.entity;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="thread-pool")
public class ThreadPoolInfo {
    private int corePoolSize = 20;
    private int maximumPoolSize = 100;
    private long keepAliveTime = 30L;

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolInfo)) {
            return false;
        }
        ThreadPoolInfo other = (ThreadPoolInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        return this.getKeepAliveTime() == other.getKeepAliveTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        long $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
        return result;
    }

    public String toString() {
        return "ThreadPoolInfo(corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ")";
    }
}

