/*
 * Decompiled with CFR 0.152.
 */
package com.github.gxhunter.config;

import com.github.gxhunter.entity.ThreadPoolInfo;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={ThreadPoolInfo.class})
@ConditionalOnBean(value={ThreadPoolInfo.class})
public class ThreadPoolAutoConfig {
    @Bean
    public ThreadPoolExecutor threadPool(ThreadPoolInfo threadPoolInfo) {
        LinkedBlockingQueue<Runnable> blockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("backup-pool-%d").build();
        return new ThreadPoolExecutor(threadPoolInfo.getCorePoolSize(), threadPoolInfo.getMaximumPoolSize(), threadPoolInfo.getKeepAliveTime(), TimeUnit.SECONDS, blockingQueue, threadFactory);
    }
}

