/*
 * Decompiled with CFR 0.152.
 */
package com.github.gxhunter.config;

import com.github.gxhunter.entity.RestTemplateInfo;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureAfter(value={HttpMessageConvertersAutoConfiguration.class})
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnMissingBean(value={RestTemplate.class})
public class RestTemplateAutoConfig {
    @Bean
    RestTemplate restTemplate(ClientHttpRequestFactory simpleClientHttpRequestFactory) {
        return new RestTemplate(simpleClientHttpRequestFactory);
    }

    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory(RestTemplateInfo info) {
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory();
        factory.setReadTimeout(info.getReadTimeout().intValue());
        factory.setConnectTimeout(info.getConnectTimeout().intValue());
        factory.setWriteTimeout(info.getWriteTimeout().intValue());
        return factory;
    }
}

