/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.RedisBase;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;

class RO_lindex
extends AbstractRedisOperation {
    RO_lindex(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    Slice response() {
        Slice key = this.params().get(0);
        LinkedList list = this.getDataFromBase(key, Lists.newLinkedList());
        if (list.isEmpty()) {
            return Response.NULL;
        }
        int index = Utils.convertToInteger(this.params().get(1).toString());
        if (index < 0 && (index = list.size() + index) < 0) {
            return Response.NULL;
        }
        if (index >= list.size()) {
            return Response.NULL;
        }
        return Response.bulkString((Slice)list.get(index));
    }
}

