/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.DependencyGraphMojo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;

@Mojo(name="for-artifact", defaultPhase=LifecyclePhase.NONE, requiresProject=false, requiresDirectInvocation=true, requiresDependencyCollection=ResolutionScope.NONE, requiresDependencyResolution=ResolutionScope.NONE, threadSafe=true)
public class ForArtifactDependencyGraphMojo
extends DependencyGraphMojo {
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="type", defaultValue="jar")
    private String type;
    @Parameter(property="classifier", defaultValue="")
    private String classifier;
    @Parameter(property="profiles")
    private List<String> profiles;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ProjectBuilder projectBuilder;

    @Override
    public MavenProject getProject() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRepositorySession(this.session.getRepositorySession());
        buildingRequest.setProject(null);
        buildingRequest.setResolveDependencies(true);
        buildingRequest.setActiveProfileIds(this.profiles);
        Artifact artifact = this.createArtifact();
        try {
            return this.projectBuilder.build(artifact, (ProjectBuildingRequest)buildingRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new IllegalStateException("Error while creating Maven project from Artifact '" + artifact + "'.", e);
        }
    }

    private Artifact createArtifact() {
        this.validateParameters();
        String groupId = this.groupId;
        String artifactId = this.artifactId;
        String version = this.version;
        String type = this.type;
        String classifier = this.classifier;
        if (StringUtils.isNotBlank((CharSequence)this.artifact)) {
            String[] parts = this.artifact.split(":");
            if (parts.length < 3) {
                throw new IllegalArgumentException("Invalid artifact definition: " + this.artifact);
            }
            groupId = parts[0];
            artifactId = parts[1];
            version = parts[2];
            if (parts.length > 3 && StringUtils.isNotBlank((CharSequence)parts[3])) {
                type = parts[3];
            }
            if (parts.length > 4) {
                classifier = parts[4];
            }
        }
        return new DefaultArtifact(groupId, artifactId, version, "compile", type, classifier, (ArtifactHandler)new DefaultArtifactHandler());
    }

    private void validateParameters() {
        if (StringUtils.isNotBlank((CharSequence)this.artifact)) {
            if (StringUtils.isNotBlank((CharSequence)this.groupId) || StringUtils.isNotBlank((CharSequence)this.artifactId) || StringUtils.isNotBlank((CharSequence)this.version)) {
                throw new IllegalArgumentException("Artifact can be defined with either 'artifact' or 'groupId'/'artifactId'/'version' but not both");
            }
        } else if (StringUtils.isBlank((CharSequence)this.groupId) || StringUtils.isBlank((CharSequence)this.artifactId) || StringUtils.isBlank((CharSequence)this.version)) {
            throw new IllegalArgumentException("'groupId', 'artifactId' and 'version' parameters have to be defined");
        }
    }
}

