/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.FongoException;
import com.github.fakemongo.impl.Aggregator;
import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.MapReduce;
import com.github.fakemongo.impl.Tuple2;
import com.github.fakemongo.impl.UpdateEngine;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.geo.GeoUtil;
import com.github.fakemongo.impl.index.GeoIndex;
import com.github.fakemongo.impl.index.IndexAbstract;
import com.github.fakemongo.impl.index.IndexFactory;
import com.github.fakemongo.impl.text.TextSearch;
import com.mongodb.AcknowledgedBulkWriteResult;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteException;
import com.mongodb.BulkWriteResult;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoder;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.FongoBulkWriteCombiner;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCursor;
import com.mongodb.InsertOptions;
import com.mongodb.InsertRequest;
import com.mongodb.LazyDBList;
import com.mongodb.LazyDBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ParallelScanOptions;
import com.mongodb.ReadPreference;
import com.mongodb.RemoveRequest;
import com.mongodb.ReplaceRequest;
import com.mongodb.UnacknowledgedBulkWriteResult;
import com.mongodb.UpdateRequest;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernError;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteRequest;
import com.mongodb.WriteResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteUpsert;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class FongoDBCollection
extends DBCollection {
    private static final Logger LOG = LoggerFactory.getLogger(FongoDBCollection.class);
    public static final String FONGO_SPECIAL_ORDER_BY = "$$$$$FONGO_ORDER_BY$$$$$";
    private static final String ID_NAME_INDEX = "_id_";
    private static final String SYSTEM_INDEXES_COLL_NAME = "system.indexes";
    private final FongoDB fongoDb;
    private final ExpressionParser expressionParser;
    private final UpdateEngine updateEngine;
    private final boolean nonIdCollection;
    private final ExpressionParser.ObjectComparator objectComparator;
    private final List<IndexAbstract> indexes = new ArrayList<IndexAbstract>();
    private final IndexAbstract _idIndex;
    private final boolean validateOnInsert;
    private final String SYSTEM_ELEMENT = "system.";

    public FongoDBCollection(FongoDB db, String name) {
        this(db, name, false, true);
    }

    public FongoDBCollection(FongoDB db, String name, boolean idIsNotUniq, boolean validateOnInsert) {
        super((DB)db, name);
        this.fongoDb = db;
        this.validateOnInsert = validateOnInsert;
        this.nonIdCollection = name.startsWith("system.");
        this.expressionParser = new ExpressionParser();
        this.updateEngine = new UpdateEngine();
        this.objectComparator = this.expressionParser.buildObjectComparator(true);
        this._idIndex = IndexFactory.create("_id", (DBObject)new BasicDBObject("_id", (Object)1), !idIsNotUniq, false);
        this.indexes.add(this._idIndex);
        if (!this.nonIdCollection) {
            this.createIndex((DBObject)new BasicDBObject("_id", (Object)1), (DBObject)new BasicDBObject("name", (Object)ID_NAME_INDEX));
        }
    }

    private synchronized WriteResult updateResult(int updateCount, boolean updatedExisting, Object upsertedId) {
        return new WriteResult(updateCount, updatedExisting, upsertedId);
    }

    private DBObject encodeDecode(DBObject dbObject, DBEncoder encoder) {
        if (dbObject instanceof LazyDBObject) {
            if (encoder == null) {
                encoder = DefaultDBEncoder.FACTORY.create();
            }
            BasicOutputBuffer outputBuffer = new BasicOutputBuffer();
            encoder.writeObject((OutputBuffer)outputBuffer, (BSONObject)dbObject);
            return DefaultDBDecoder.FACTORY.create().decode(outputBuffer.toByteArray(), (DBCollection)this);
        }
        return dbObject;
    }

    public synchronized WriteResult insert(List<? extends DBObject> documents, InsertOptions insertOptions) {
        WriteConcern writeConcern = insertOptions.getWriteConcern() != null ? insertOptions.getWriteConcern() : this.getWriteConcern();
        for (DBObject dBObject : documents) {
            DBObject cloned = this.filterLists(Util.cloneIdFirst(this.encodeDecode(dBObject, insertOptions.getDbEncoder())));
            if (LOG.isDebugEnabled()) {
                LOG.debug("insert: " + cloned);
            }
            ObjectId id = this.putIdIfNotPresent(cloned);
            if (!(dBObject instanceof LazyDBObject) && dBObject.get("_id") == null) {
                dBObject.put("_id", Util.clone(id));
            }
            if (!this.getName().equalsIgnoreCase(SYSTEM_INDEXES_COLL_NAME) && this.validateOnInsert) {
                this._checkObject(dBObject, false, false);
            }
            this.putSizeCheck(cloned, writeConcern);
        }
        if (!writeConcern.isAcknowledged()) {
            return WriteResult.unacknowledged();
        }
        return new WriteResult(documents.size(), false, null);
    }

    boolean enforceDuplicates(WriteConcern concern) {
        WriteConcern writeConcern = concern == null ? this.getWriteConcern() : concern;
        return writeConcern.isAcknowledged();
    }

    public ObjectId putIdIfNotPresent(DBObject obj) {
        Object object = obj.get("_id");
        if (object == null) {
            ObjectId id = new ObjectId();
            obj.put("_id", (Object)id);
            return id;
        }
        if (object instanceof ObjectId) {
            ObjectId id = (ObjectId)object;
            return id;
        }
        return null;
    }

    public void putSizeCheck(DBObject obj, WriteConcern concern) {
        if (this._idIndex.size() > 100000) {
            throw new FongoException("Whoa, hold up there.  Fongo's designed for lightweight testing.  100,000 items per collection max");
        }
        this.addToIndexes(obj, null, concern);
    }

    public DBObject filterLists(DBObject dbo) {
        if (dbo == null) {
            return null;
        }
        dbo = Util.clone(dbo);
        for (Map.Entry<String, Object> entry : Util.entrySet(dbo)) {
            Object replacementValue = this.replaceListAndMap(entry.getValue());
            dbo.put(entry.getKey(), replacementValue);
        }
        return dbo;
    }

    public Object replaceListAndMap(Object value) {
        Object replacementValue = BSON.applyEncodingHooks((Object)value);
        if (ExpressionParser.isDbObject(replacementValue)) {
            replacementValue = this.filterLists(ExpressionParser.toDbObject(replacementValue));
        } else if (replacementValue instanceof Collection) {
            BasicDBList list = new BasicDBList();
            for (Object listItem : (Collection)replacementValue) {
                list.add(this.replaceListAndMap(listItem));
            }
            replacementValue = list;
        } else if (replacementValue instanceof DBObject) {
            replacementValue = this.filterLists((DBObject)replacementValue);
        } else if (replacementValue instanceof Object[]) {
            BasicDBList list = new BasicDBList();
            for (Object listItem : (Object[])replacementValue) {
                list.add(this.replaceListAndMap(listItem));
            }
            replacementValue = list;
        } else if (replacementValue instanceof long[]) {
            BasicDBList list = new BasicDBList();
            long[] lArray = (long[])replacementValue;
            int listItem = lArray.length;
            for (int i = 0; i < listItem; ++i) {
                Long listItem2 = lArray[i];
                list.add(this.replaceListAndMap(listItem2));
            }
            replacementValue = list;
        } else if (replacementValue instanceof int[]) {
            BasicDBList list = new BasicDBList();
            int[] nArray = (int[])replacementValue;
            int listItem = nArray.length;
            for (int i = 0; i < listItem; ++i) {
                Integer listItem3 = nArray[i];
                list.add(this.replaceListAndMap(listItem3));
            }
            replacementValue = list;
        } else if (replacementValue instanceof double[]) {
            BasicDBList list = new BasicDBList();
            double[] dArray = (double[])replacementValue;
            int listItem = dArray.length;
            for (int i = 0; i < listItem; ++i) {
                Double listItem4 = dArray[i];
                list.add(this.replaceListAndMap(listItem4));
            }
            replacementValue = list;
        } else if (replacementValue instanceof float[]) {
            BasicDBList list = new BasicDBList();
            float[] fArray = (float[])replacementValue;
            int listItem = fArray.length;
            for (int i = 0; i < listItem; ++i) {
                Float listItem5 = Float.valueOf(fArray[i]);
                list.add(this.replaceListAndMap(listItem5));
            }
            replacementValue = list;
        } else if (replacementValue instanceof boolean[]) {
            BasicDBList list = new BasicDBList();
            boolean[] blArray = (boolean[])replacementValue;
            int listItem = blArray.length;
            for (int i = 0; i < listItem; ++i) {
                Boolean listItem6 = blArray[i];
                list.add(this.replaceListAndMap(listItem6));
            }
            replacementValue = list;
        } else if (replacementValue instanceof Map) {
            BasicDBObject newDbo = new BasicDBObject();
            for (Map.Entry entry : ((Map)replacementValue).entrySet()) {
                newDbo.put(entry.getKey(), this.replaceListAndMap(entry.getValue()));
            }
            replacementValue = newDbo;
        } else if (replacementValue instanceof Binary) {
            replacementValue = ((Binary)replacementValue).getData();
        }
        return Util.clone(replacementValue);
    }

    protected synchronized void fInsert(DBObject obj, WriteConcern concern) {
        this.putIdIfNotPresent(obj);
        this.putSizeCheck(obj, concern);
    }

    public synchronized WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi, WriteConcern concern, DBEncoder encoder) throws MongoException {
        Object upsertedId;
        boolean updatedExisting;
        int updatedDocuments;
        block10: {
            block9: {
                String key;
                q = this.filterLists(q);
                if ((o = this.filterLists(o)) == null) {
                    throw new IllegalArgumentException("update can not be null");
                }
                if (concern == null) {
                    throw new IllegalArgumentException("Write concern can not be null");
                }
                if (!o.keySet().isEmpty() && !(key = (String)o.keySet().iterator().next()).startsWith("$")) {
                    this._checkObject(o, false, false);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("update(" + q + ", " + o + ", " + upsert + ", " + multi + ")");
                }
                if (o.containsField("_id") && q.containsField("_id") && this.objectComparator.compare(o.get("_id"), q.get("_id")) != 0) {
                    LOG.warn("can not change _id of a document query={}, document={}", (Object)q, (Object)o);
                    throw this.fongoDb.writeConcernException(16837, "can not change _id of a document _id");
                }
                updatedDocuments = 0;
                boolean idOnlyUpdate = q.containsField("_id") && q.keySet().size() == 1;
                updatedExisting = false;
                upsertedId = null;
                if (!idOnlyUpdate || !this.isNotUpdateCommand(o)) break block9;
                if (!o.containsField("_id")) {
                    o.put("_id", Util.clone(q.get("_id")));
                } else {
                    o.put("_id", Util.clone(o.get("_id")));
                }
                Iterator oldObjects = this._idIndex.retrieveObjects(q).iterator();
                if (!oldObjects.hasNext()) break block10;
                this.addToIndexes(Util.clone(o), oldObjects.hasNext() ? (DBObject)oldObjects.next() : null, concern);
                ++updatedDocuments;
                updatedExisting = true;
                break block10;
            }
            Filter filter = this.buildFilter(q);
            for (DBObject obj : this.filterByIndexes(q)) {
                if (!filter.apply(obj)) continue;
                DBObject newObject = Util.clone(obj);
                this.updateEngine.doUpdate(newObject, o, q, false);
                this.addToIndexes(newObject, obj, concern);
                ++updatedDocuments;
                updatedExisting = true;
                if (multi) continue;
                break;
            }
        }
        if (updatedDocuments == 0 && upsert) {
            BasicDBObject newObject = this.createUpsertObject(q);
            this.fInsert(this.updateEngine.doUpdate((DBObject)newObject, o, q, true), concern);
            ++updatedDocuments;
            updatedExisting = false;
            upsertedId = newObject.get("_id");
        }
        return this.updateResult(updatedDocuments, updatedExisting, upsertedId);
    }

    protected DBObject _checkObject(DBObject o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new IllegalArgumentException("can't be null");
        }
        if (o.isPartialObject() && !query) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        if (!query) {
            this._checkKeys(o);
        }
        return o;
    }

    private void _checkKeys(DBObject o) {
        if (o instanceof LazyDBObject || o instanceof LazyDBList) {
            return;
        }
        for (String s : o.keySet()) {
            this.validateKey(s);
            this._checkValue(o.get(s));
        }
    }

    private void _checkKeys(Map<String, Object> o) {
        for (Map.Entry<String, Object> cur : o.entrySet()) {
            this.validateKey(cur.getKey());
            this._checkValue(cur.getValue());
        }
    }

    private void _checkValues(List list) {
        for (Object cur : list) {
            this._checkValue(cur);
        }
    }

    private void _checkValue(Object value) {
        if (value instanceof DBObject) {
            this._checkKeys((DBObject)value);
        } else if (value instanceof Map) {
            this._checkKeys((Map)value);
        } else if (value instanceof List) {
            this._checkValues((List)value);
        }
    }

    private void validateKey(String s) {
        if (s.contains("\u0000")) {
            throw new IllegalArgumentException("Document field names can't have a NULL character. (Bad Key: '" + s + "')");
        }
        if (s.contains(".")) {
            throw new IllegalArgumentException("Document field names can't have a . in them. (Bad Key: '" + s + "')");
        }
        if (s.startsWith("$")) {
            throw new IllegalArgumentException("Document field names can't start with '$' (Bad Key: '" + s + "')");
        }
    }

    private List idsIn(DBObject query) {
        Object idValue;
        Object object = idValue = query != null ? query.get("_id") : null;
        if (idValue == null || query.keySet().size() > 1) {
            return Collections.emptyList();
        }
        if (ExpressionParser.isDbObject(idValue)) {
            DBObject idDbObject = ExpressionParser.toDbObject(idValue);
            Collection inList = (Collection)idDbObject.get("$in");
            if (inList != null) {
                Object[] inListArray = inList.toArray(new Object[inList.size()]);
                Arrays.sort(inListArray, this.objectComparator);
                return Arrays.asList(inListArray);
            }
            if (!this.isNotUpdateCommand(idValue)) {
                return Collections.emptyList();
            }
        }
        return Collections.singletonList(Util.clone(idValue));
    }

    protected BasicDBObject createUpsertObject(DBObject q) {
        BasicDBObject newObject = new BasicDBObject();
        newObject.markAsPartialObject();
        BasicDBObject filteredQuery = new BasicDBObject();
        for (String key : q.keySet()) {
            Object value = q.get(key);
            if (!this.isNotUpdateCommand(value)) continue;
            if ("$and".equals(key)) {
                List values = (List)value;
                for (DBObject dbObject : values) {
                    filteredQuery.putAll((BSONObject)dbObject);
                }
                continue;
            }
            filteredQuery.put((Object)key, value);
        }
        this.updateEngine.mergeEmbeddedValueFromQuery(newObject, (DBObject)filteredQuery);
        return newObject;
    }

    public boolean isNotUpdateCommand(Object value) {
        boolean okValue = true;
        if (ExpressionParser.isDbObject(value)) {
            for (String innerKey : ExpressionParser.toDbObject(value).keySet()) {
                if (!innerKey.startsWith("$")) continue;
                okValue = false;
            }
        }
        return okValue;
    }

    public WriteResult remove(DBObject query, WriteConcern writeConcern) {
        return this.remove(query, writeConcern, null);
    }

    public synchronized WriteResult remove(DBObject o, WriteConcern concern, DBEncoder encoder) throws MongoException {
        o = this.filterLists(o);
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove: " + o);
        }
        int updatedDocuments = 0;
        Collection<DBObject> objectsByIndex = this.filterByIndexes(o);
        Filter filter = this.buildFilter(o);
        ArrayList<DBObject> ids = new ArrayList<DBObject>();
        for (DBObject object : objectsByIndex) {
            if (!filter.apply(object)) continue;
            ids.add(object);
        }
        for (DBObject object : ids) {
            LOG.debug("remove object : {}", (Object)object);
            this.removeFromIndexes(object);
            ++updatedDocuments;
        }
        return this.updateResult(updatedDocuments, true, null);
    }

    public synchronized void createIndex(DBObject keys, DBObject options) {
        boolean sparse;
        boolean unique;
        FongoDBCollection indexColl = this.fongoDb.getCollection(SYSTEM_INDEXES_COLL_NAME);
        BasicDBObject rec = new BasicDBObject();
        rec.append("v", (Object)1);
        rec.append("key", (Object)keys);
        rec.append("ns", (Object)this.nsName());
        if (options != null && options.containsField("name")) {
            rec.append("name", options.get("name"));
        } else {
            StringBuilder sb = new StringBuilder();
            boolean firstLoop = true;
            for (String keyName : keys.keySet()) {
                if (!firstLoop) {
                    sb.append("_");
                }
                sb.append(keyName).append("_").append(keys.get(keyName));
                firstLoop = false;
            }
            rec.append("name", (Object)sb.toString());
        }
        DBObject oldIndex = indexColl.findOne((DBObject)rec);
        if (oldIndex != null) {
            for (Map.Entry<String, Object> entry : Util.entrySet(options)) {
                if (entry.getValue().equals(oldIndex.get(entry.getKey()))) continue;
                this.fongoDb.notOkErrorResult(85, String.format("Index with name: %s already exists with different options", this.nsName())).throwOnError();
            }
            return;
        }
        boolean bl = unique = options != null && options.get("unique") != null && (Boolean.TRUE.equals(options.get("unique")) || "1".equals(options.get("unique")) || Integer.valueOf(1).equals(options.get("unique")));
        if (unique) {
            rec.append("unique", (Object)unique);
        }
        boolean bl2 = sparse = options != null && options.get("sparse") != null && (Boolean.TRUE.equals(options.get("sparse")) || "1".equals(options.get("sparse")) || Integer.valueOf(1).equals(options.get("sparse")));
        if (sparse) {
            rec.append("sparse", (Object)sparse);
        }
        rec.putAll((BSONObject)options);
        try {
            IndexAbstract index = IndexFactory.create((String)rec.get("name"), keys, unique, sparse);
            List<List<Object>> notUnique = index.addAll(this._idIndex.values());
            if (!notUnique.isEmpty()) {
                if (this.enforceDuplicates(this.getWriteConcern())) {
                    this.fongoDb.notOkErrorResult(11000, "E11000 duplicate key error index: " + this.getFullName() + ".$" + rec.get("name") + "  dup key: { : " + notUnique + " }").throwOnError();
                }
                return;
            }
            this.indexes.add(index);
        }
        catch (MongoException me) {
            this.fongoDb.errorResult(me.getCode(), me.getMessage()).throwOnError();
        }
        indexColl.insert(new DBObject[]{rec});
    }

    DBObject findOne(DBObject pRef, DBObject projection, DBObject sort, ReadPreference readPreference, long maxTime, TimeUnit maxTimeUnit) {
        List<DBObject> objects;
        BasicDBObject query = new BasicDBObject("$query", (Object)pRef);
        if (sort != null) {
            query.put("$orderby", (Object)sort);
        }
        return (objects = this.__find((DBObject)query, projection, 0, 1, 1, 0, readPreference, null, null)).size() > 0 ? this.replaceWithObjectClass(objects.get(0)) : null;
    }

    List<DBObject> __find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder, DBEncoder encoder) {
        return this.__find(ref, fields, numToSkip, batchSize, limit, options, readPref, decoder);
    }

    public DBCursor find() {
        return this.find((DBObject)new BasicDBObject());
    }

    public DBCursor find(DBObject query) {
        return this.find(query, null);
    }

    public DBCursor find(DBObject query, DBObject projection) {
        return new FongoDBCursor(this, query, projection);
    }

    synchronized List<DBObject> __find(DBObject pRef, DBObject fields, int numToSkip, int batchSize, int limit, int options, ReadPreference readPref, DBDecoder decoder) throws MongoException {
        DBObject ref = this.filterLists((DBObject)(pRef == null ? new BasicDBObject() : pRef));
        long maxScan = Long.MAX_VALUE;
        if (LOG.isDebugEnabled()) {
            LOG.debug("find({}, {}).skip({}).limit({})", new Object[]{ref, fields, numToSkip, limit});
            LOG.debug("the db {} looks like {}", (Object)this.getDB().getName(), (Object)this._idIndex.size());
        }
        DBObject orderby = null;
        if (ref.containsField("$orderby")) {
            orderby = ExpressionParser.toDbObject(ref.get("$orderby"));
        }
        if (ref.containsField("$maxScan")) {
            maxScan = ((Number)ref.get("$maxScan")).longValue();
        }
        if (ref.containsField("$query")) {
            ref = ExpressionParser.toDbObject(ref.get("$query"));
        }
        Filter filter = this.buildFilter(ref);
        int foundCount = 0;
        int upperLimit = Integer.MAX_VALUE;
        if (limit > 0) {
            upperLimit = limit;
        }
        Collection<DBObject> objectsFromIndex = this.filterByIndexes(ref);
        List<DBObject> results = new ArrayList<DBObject>();
        List objects = this.idsIn(ref);
        if (!objects.isEmpty()) {
            if (orderby == null) {
                orderby = new BasicDBObject("_id", (Object)1);
            } else {
                objectsFromIndex = this.sortObjects((DBObject)new BasicDBObject("_id", (Object)1), objectsFromIndex);
            }
        }
        int seen = 0;
        Collection<DBObject> objectsToSearch = this.sortObjects(orderby, objectsFromIndex);
        Iterator iter = objectsToSearch.iterator();
        while (iter.hasNext() && foundCount < upperLimit && maxScan-- > 0L) {
            DBObject dbo = (DBObject)iter.next();
            if (!filter.apply(dbo) || seen++ < numToSkip) continue;
            ++foundCount;
            DBObject clonedDbo = Util.clone(dbo);
            if (this.nonIdCollection) {
                clonedDbo.removeField("_id");
            }
            clonedDbo.removeField(FONGO_SPECIAL_ORDER_BY);
            results.add(clonedDbo);
        }
        if (!Util.isDBObjectEmpty(fields)) {
            results = this.applyProjections(results, fields);
        }
        LOG.debug("found results {}", results);
        return this.replaceWithObjectClass(results);
    }

    private Collection<DBObject> filterByIndexes(DBObject ref) {
        IndexAbstract matchingIndex;
        Collection<Object> dbObjectIterable = null;
        if (ref != null && (matchingIndex = this.searchIndex(ref)) != null) {
            dbObjectIterable = matchingIndex.retrieveObjects(ref);
            if (LOG.isDebugEnabled()) {
                LOG.debug("restrict with index {}, from {} to {} elements", new Object[]{matchingIndex.getName(), this._idIndex.size(), dbObjectIterable == null ? 0 : dbObjectIterable.size()});
            }
        }
        if (dbObjectIterable == null) {
            dbObjectIterable = this._idIndex.values();
        }
        return dbObjectIterable;
    }

    private List<DBObject> applyProjections(List<DBObject> results, DBObject projection) {
        ArrayList<DBObject> ret = new ArrayList<DBObject>(results.size());
        for (DBObject result : results) {
            DBObject projectionMacthedResult = FongoDBCollection.applyProjections(result, projection);
            if (null == projectionMacthedResult) continue;
            ret.add(projectionMacthedResult);
        }
        return ret;
    }

    private static void addValuesAtPath(BasicDBObject ret, DBObject dbo, List<String> path, int startIndex) {
        String subKey = path.get(startIndex);
        Object value = dbo.get(subKey);
        if (path.size() > startIndex + 1) {
            if (ExpressionParser.isDbObject(value) && !(value instanceof List)) {
                BasicDBObject nb = (BasicDBObject)ret.get(subKey);
                if (nb == null) {
                    nb = new BasicDBObject();
                }
                ret.append(subKey, (Object)nb);
                FongoDBCollection.addValuesAtPath(nb, ExpressionParser.toDbObject(value), path, startIndex + 1);
            } else if (value instanceof List) {
                BasicDBList list = FongoDBCollection.getListForKey(ret, subKey);
                int idx = 0;
                for (Object v : (List)value) {
                    if (ExpressionParser.isDbObject(v)) {
                        BasicDBObject nb;
                        if (list.size() > idx) {
                            nb = (BasicDBObject)list.get(idx);
                        } else {
                            nb = new BasicDBObject();
                            list.add((Object)nb);
                        }
                        FongoDBCollection.addValuesAtPath(nb, ExpressionParser.toDbObject(v), path, startIndex + 1);
                    }
                    ++idx;
                }
            }
        } else if (value != null) {
            ret.append(subKey, value);
        }
    }

    private static void pruneValuesAtPath(DBObject ret, List<String> path, int startIndex) {
        String subKey = path.get(startIndex);
        if (!ret.containsField(subKey)) {
            return;
        }
        if (path.size() == startIndex + 1) {
            ret.removeField(subKey);
        } else {
            Object value = ret.get(subKey);
            if (ExpressionParser.isDbObject(value) && !(value instanceof List)) {
                FongoDBCollection.pruneValuesAtPath((DBObject)((BasicDBObject)value), path, startIndex + 1);
            } else if (value instanceof List) {
                BasicDBList list = (BasicDBList)value;
                for (Object v : (List)value) {
                    if (!ExpressionParser.isDbObject(v)) continue;
                    FongoDBCollection.pruneValuesAtPath(ExpressionParser.toDbObject(v), path, startIndex + 1);
                }
            }
        }
    }

    private static BasicDBList getListForKey(BasicDBObject ret, String subKey) {
        BasicDBList list;
        if (ret.containsField(subKey)) {
            list = (BasicDBList)ret.get(subKey);
        } else {
            list = new BasicDBList();
            ret.append(subKey, (Object)list);
        }
        return list;
    }

    private DBObject replaceWithObjectClass(DBObject resultObject) {
        if (resultObject == null || this.getObjectClass() == null) {
            return resultObject;
        }
        DBObject targetObject = this.instantiateObjectClassInstance();
        for (String key : resultObject.keySet()) {
            targetObject.put(key, resultObject.get(key));
        }
        return targetObject;
    }

    private List<DBObject> replaceWithObjectClass(List<DBObject> resultObjects) {
        ArrayList<DBObject> targetObjects = new ArrayList<DBObject>(resultObjects.size());
        for (DBObject resultObject : resultObjects) {
            targetObjects.add(this.replaceWithObjectClass(resultObject));
        }
        return targetObjects;
    }

    private DBObject instantiateObjectClassInstance() {
        try {
            return ExpressionParser.toDbObject(this.getObjectClass().newInstance());
        }
        catch (InstantiationException e) {
            throw new MongoInternalException("Can't create instance of type: " + this.getObjectClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MongoInternalException("Can't create instance of type: " + this.getObjectClass(), (Throwable)e);
        }
    }

    public static DBObject applyProjections(DBObject result, DBObject projectionObject) {
        BasicDBObject ret;
        LOG.debug("applying projections {}", (Object)projectionObject);
        if (Util.isDBObjectEmpty(projectionObject)) {
            if (Util.isDBObjectEmpty(result)) {
                return null;
            }
            return Util.cloneIdFirst(result);
        }
        if (result == null) {
            return null;
        }
        int inclusionCount = 0;
        int exclusionCount = 0;
        ArrayList<String> projectionFields = new ArrayList<String>();
        boolean wasIdExcluded = false;
        ArrayList<Tuple2<List<String>, Boolean>> projections = new ArrayList<Tuple2<List<String>, Boolean>>();
        for (String projectionKey : projectionObject.keySet()) {
            Object object = projectionObject.get(projectionKey);
            boolean included = false;
            boolean project = false;
            if (object instanceof Number) {
                included = ((Number)object).intValue() > 0;
            } else if (object instanceof Boolean) {
                included = (Boolean)object;
            } else if (ExpressionParser.isDbObject(object)) {
                project = true;
                projectionFields.add(projectionKey);
            } else if (object.toString().equals("text")) {
                included = true;
            } else {
                String msg = "Projection `" + projectionKey + "' has a value that Fongo doesn't know how to handle: " + object + " (" + (object == null ? " " : object.getClass() + ")");
                throw new IllegalArgumentException(msg);
            }
            List<String> projectionPath = Util.split(projectionKey);
            if (!"_id".equals(projectionKey)) {
                if (included) {
                    ++inclusionCount;
                } else if (!project) {
                    ++exclusionCount;
                }
            } else {
                boolean bl = wasIdExcluded = !included;
            }
            if (projectionPath.size() <= 0) continue;
            projections.add(new Tuple2<List<String>, Boolean>(projectionPath, included));
        }
        if (inclusionCount > 0 && exclusionCount > 0) {
            throw new IllegalArgumentException("You cannot combine inclusion and exclusion semantics in a single projection with the exception of the _id field: " + projectionObject);
        }
        if (exclusionCount > 0) {
            ret = (BasicDBObject)Util.clone(result);
        } else {
            ret = new BasicDBObject();
            if (!wasIdExcluded) {
                ret.append("_id", Util.clone(result.get("_id")));
            } else if (inclusionCount == 0) {
                ret = (BasicDBObject)Util.clone(result);
                ret.removeField("_id");
            }
        }
        for (Tuple2 tuple2 : projections) {
            if (((Boolean)tuple2._2).booleanValue()) {
                FongoDBCollection.addValuesAtPath(ret, result, (List)tuple2._1, 0);
                continue;
            }
            FongoDBCollection.pruneValuesAtPath((DBObject)ret, (List)tuple2._1, 0);
        }
        if (!projectionFields.isEmpty()) {
            for (String string : projectionObject.keySet()) {
                if (!projectionFields.contains(string)) continue;
                Object projectionValue = projectionObject.get(string);
                boolean isElemMatch = ((BasicDBObject)projectionObject.get(string)).containsField("$elemMatch");
                boolean isSlice = ((BasicDBObject)projectionObject.get(string)).containsField("$slice");
                if (isElemMatch) {
                    ret.removeField(string);
                    BasicDBList searchIn = (BasicDBList)result.get(string);
                    BasicDBObject searchFor = (BasicDBObject)((BasicDBObject)projectionObject.get(string)).get("$elemMatch");
                    String searchKey = (String)searchFor.keySet().toArray()[0];
                    int pos = -1;
                    int length = searchIn.size();
                    for (int i = 0; i < length; ++i) {
                        boolean matches;
                        ObjectId m2;
                        ObjectId m1;
                        BasicDBObject fieldToSearch = (BasicDBObject)searchIn.get(i);
                        if (!fieldToSearch.containsField(searchKey)) continue;
                        if (searchFor.get(searchKey) instanceof ObjectId && fieldToSearch.get(searchKey) instanceof String) {
                            m1 = new ObjectId(searchFor.get(searchKey).toString());
                            m2 = new ObjectId(String.valueOf(fieldToSearch.get(searchKey)));
                            matches = m1.equals((Object)m2);
                        } else if (searchFor.get(searchKey) instanceof String && fieldToSearch.get(searchKey) instanceof ObjectId) {
                            m1 = new ObjectId(String.valueOf(searchFor.get(searchKey)));
                            m2 = new ObjectId(fieldToSearch.get(searchKey).toString());
                            matches = m1.equals((Object)m2);
                        } else {
                            matches = fieldToSearch.get(searchKey).equals(searchFor.get(searchKey));
                        }
                        if (!matches) continue;
                        pos = i;
                        break;
                    }
                    if (pos == -1) continue;
                    BasicDBList append = new BasicDBList();
                    append.add(searchIn.get(pos));
                    ret.append(string, (Object)append);
                    LOG.debug("$elemMatch projection of field \"{}\", gave result: {} ({})", new Object[]{string, ret, ret.getClass()});
                    continue;
                }
                if (isSlice) {
                    if (FongoDBCollection.slice(result, projectionObject, string, projectionValue, ret)) continue;
                    ret = null;
                    continue;
                }
                String msg = "Projection `" + string + "' has a value that Fongo doesn't know how to handle: " + projectionValue + " (" + (projectionValue == null ? " " : projectionValue.getClass() + ")");
                throw new IllegalArgumentException(msg);
            }
        }
        return ret;
    }

    private static boolean slice(DBObject result, DBObject projectionObject, String projectionKey, Object projectionValue, BasicDBObject ret) throws MongoException {
        int limit;
        ret.removeField(projectionKey);
        BasicDBList searchIn = (BasicDBList)result.get(projectionKey);
        if (searchIn == null) {
            ret.clear();
            return false;
        }
        BasicDBObject basicDBObject = (BasicDBObject)projectionObject.get(projectionKey);
        int start = 0;
        if (basicDBObject.get("$slice") instanceof Number) {
            limit = ((Number)basicDBObject.get("$slice")).intValue();
            if (limit < 0) {
                start = limit;
                limit = -limit;
            }
        } else if (basicDBObject.get("$slice") instanceof List) {
            List range = (List)basicDBObject.get("$slice");
            if (range.size() != 2) {
                throw new IllegalArgumentException("$slice with an Array must have size of 2");
            }
            start = (Integer)range.get(0);
            limit = (Integer)range.get(1);
        } else {
            String msg = "Projection `" + projectionKey + "' has a value that Fongo doesn't know how to handle: " + projectionValue + " (" + (projectionValue == null ? " " : projectionValue.getClass() + ")");
            throw new IllegalArgumentException(msg);
        }
        if (limit < 0) {
            throw new MongoException("Can't canonicalize query: BadValue $slice limit must be positive");
        }
        BasicDBList slice = new BasicDBList();
        int startArray = start < 0 ? Math.max(0, searchIn.size() + start) + 1 : Math.min(searchIn.size(), start) + 1;
        int i = startArray;
        for (int count = 0; i <= searchIn.size() && count < limit; ++i, ++count) {
            slice.add(searchIn.get(i - 1));
        }
        ret.put((Object)projectionKey, (Object)slice);
        return true;
    }

    public Collection<DBObject> sortObjects(final DBObject orderby, Collection<DBObject> objects) {
        Collection<DBObject> objectsToSearch = objects;
        if (orderby != null) {
            final Set orderbyKeySet = orderby.keySet();
            if (!orderbyKeySet.isEmpty()) {
                DBObject[] objectsToSort = objects.toArray(new DBObject[objects.size()]);
                Arrays.sort(objectsToSort, new Comparator<DBObject>(){

                    @Override
                    public int compare(DBObject o1, DBObject o2) {
                        for (String sortKey : orderbyKeySet) {
                            List<String> path = Util.split(sortKey);
                            int sortDirection = (Integer)orderby.get(sortKey);
                            List<Object> o1list = FongoDBCollection.this.expressionParser.getEmbeddedValues(path, o1);
                            List<Object> o2list = FongoDBCollection.this.expressionParser.getEmbeddedValues(path, o2);
                            int compareValue = FongoDBCollection.this.expressionParser.compareLists(o1list, o2list) * sortDirection;
                            if (compareValue == 0) continue;
                            return compareValue;
                        }
                        return 0;
                    }
                });
                objectsToSearch = Arrays.asList(objectsToSort);
            }
        } else {
            objectsToSearch = this.sortObjects((DBObject)new BasicDBObject(FONGO_SPECIAL_ORDER_BY, (Object)1), objects);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted objectsToSearch " + objectsToSearch);
        }
        return objectsToSearch;
    }

    public synchronized long getCount(DBObject pQuery, DBObject projection, long limit, long skip, ReadPreference readPreference, long maxTime, TimeUnit maxTimeUnit, BsonValue hint) {
        DBObject query = this.filterLists(pQuery);
        Filter filter = query == null ? ExpressionParser.AllFilter : this.buildFilter(query);
        long count = 0L;
        long upperLimit = Long.MAX_VALUE;
        if (limit > 0L) {
            upperLimit = limit;
        }
        int seen = 0;
        Iterator<DBObject> iter = this.filterByIndexes(query).iterator();
        while (iter.hasNext() && count < upperLimit) {
            DBObject value = iter.next();
            if (!filter.apply(value) || (long)seen++ < skip) continue;
            ++count;
        }
        return count;
    }

    public synchronized long getCount(DBObject query, DBObject fields, ReadPreference readPrefs) {
        return this.getCount(query, fields, 0L, 0L);
    }

    public synchronized DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert) {
        LOG.debug("findAndModify({}, {}, {}, {}, {}, {}, {}", new Object[]{query, fields, sort, remove, update, returnNew, upsert});
        query = this.filterLists(query);
        update = this.filterLists(update);
        Filter filter = this.buildFilter(query);
        Collection<DBObject> objectsToSearch = this.sortObjects(sort, this.filterByIndexes(query));
        DBObject beforeObject = null;
        DBObject afterObject = null;
        for (DBObject dbo : objectsToSearch) {
            if (!filter.apply(dbo)) continue;
            beforeObject = dbo;
            if (!remove) {
                afterObject = Util.clone(beforeObject);
                this.updateEngine.doUpdate(afterObject, update, query, false);
                this.addToIndexes(afterObject, beforeObject, this.getWriteConcern());
                break;
            }
            this.remove(dbo);
            return dbo;
        }
        if (beforeObject != null && !returnNew) {
            return this.replaceWithObjectClass(FongoDBCollection.applyProjections(beforeObject, fields));
        }
        if (beforeObject == null && upsert && !remove) {
            beforeObject = new BasicDBObject();
            afterObject = this.createUpsertObject(query);
            this.fInsert(this.updateEngine.doUpdate(afterObject, update, query, upsert), this.getWriteConcern());
        }
        DBObject resultObject = returnNew ? FongoDBCollection.applyProjections(afterObject, fields) : FongoDBCollection.applyProjections(beforeObject, fields);
        return this.replaceWithObjectClass(resultObject);
    }

    public synchronized List distinct(String key, DBObject pQuery, ReadPreference readPreference) {
        DBObject query = this.filterLists(pQuery);
        LinkedHashSet<Object> results = new LinkedHashSet<Object>();
        Filter filter = this.buildFilter(query);
        for (DBObject value : this.filterByIndexes(query)) {
            if (!filter.apply(value)) continue;
            List<Object> keyValues = this.expressionParser.getEmbeddedValues(key, value);
            for (Object keyValue : keyValues) {
                if (keyValue instanceof List) {
                    results.addAll((List)keyValue);
                    continue;
                }
                results.add(keyValue);
            }
        }
        return new ArrayList(results);
    }

    public AggregationOutput aggregate(List<? extends DBObject> pipeline, ReadPreference readPreference) {
        Aggregator aggregator = new Aggregator(this.fongoDb, this, pipeline);
        return new AggregationOutput(aggregator.computeResult());
    }

    public List<Cursor> parallelScan(ParallelScanOptions options) {
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        for (int i = 0; i < options.getNumCursors(); ++i) {
            cursors.add((Cursor)new FongoDBCursor(this, (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject()));
        }
        return cursors;
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, Boolean bypassDocumentValidation, List<WriteRequest> writeRequests, WriteConcern aWriteConcern) {
        Assertions.isTrueArgument((String)"writes is not an empty list", (!writeRequests.isEmpty() ? 1 : 0) != 0);
        WriteConcern writeConcern = aWriteConcern == null ? this.getWriteConcern() : aWriteConcern;
        int idx = 0;
        FongoBulkWriteCombiner combiner = new FongoBulkWriteCombiner(writeConcern);
        for (WriteRequest req : writeRequests) {
            block11: {
                WriteResult wr;
                ReplaceRequest r;
                if (req instanceof ReplaceRequest) {
                    r = (ReplaceRequest)req;
                    this._checkObject(r.getDocument(), false, false);
                    wr = this.update(r.getQuery(), r.getDocument(), r.isUpsert(), false, writeConcern, null);
                    combiner.addReplaceResult(idx, wr);
                } else if (req instanceof UpdateRequest) {
                    r = (UpdateRequest)req;
                    this.checkMultiUpdateDocument(r.getUpdate());
                    wr = this.update(r.getQuery(), r.getUpdate(), r.isUpsert(), r.isMulti(), writeConcern, null);
                    combiner.addUpdateResult(idx, wr);
                } else if (req instanceof RemoveRequest) {
                    r = (RemoveRequest)req;
                    wr = this.remove(r.getQuery(), writeConcern, null);
                    combiner.addRemoveResult(wr);
                } else {
                    if (req instanceof InsertRequest) {
                        r = (InsertRequest)req;
                        try {
                            wr = this.insert(new DBObject[]{r.getDocument()});
                            combiner.addInsertResult(wr);
                            break block11;
                        }
                        catch (WriteConcernException e) {
                            combiner.addInsertError(idx, e);
                            if (ordered) {
                                break;
                            }
                            break block11;
                        }
                    }
                    throw new NotImplementedException();
                }
            }
            ++idx;
        }
        combiner.throwOnError();
        return combiner.getBulkWriteResult(writeConcern);
    }

    @Deprecated
    BulkWriteResult executeBulkWriteOperation(boolean ordered, List<WriteRequest> writeRequests, WriteConcern aWriteConcern) {
        return this.executeBulkWriteOperation(ordered, false, writeRequests, aWriteConcern);
    }

    private void checkMultiUpdateDocument(DBObject updateDocument) throws IllegalArgumentException {
        for (String key : updateDocument.keySet()) {
            if (key.startsWith("$")) continue;
            throw new IllegalArgumentException("Invalid BSON field name " + key);
        }
    }

    public List<DBObject> getIndexInfo() {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put((Object)"ns", (Object)this.getFullName());
        DBCursor cur = this.getDB().getCollection(SYSTEM_INDEXES_COLL_NAME).find((DBObject)cmd);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        while (cur.hasNext()) {
            list.add(cur.next());
        }
        return list;
    }

    public void dropIndex(String indexName) {
        if ("*".equalsIgnoreCase(indexName)) {
            this._dropIndexes();
        } else {
            this._dropIndex(indexName);
        }
    }

    protected synchronized void _dropIndex(String name) throws MongoException {
        FongoDBCollection indexColl = this.fongoDb.getCollection(SYSTEM_INDEXES_COLL_NAME);
        WriteResult wr = indexColl.remove((DBObject)new BasicDBObject("name", (Object)name).append("ns", (Object)this.nsName()), WriteConcern.ACKNOWLEDGED);
        boolean isDrop = wr.getN() == 1;
        ListIterator<IndexAbstract> iterator = this.indexes.listIterator();
        while (iterator.hasNext()) {
            IndexAbstract index = iterator.next();
            if (!index.getName().equals(name)) continue;
            iterator.remove();
            isDrop = true;
            break;
        }
        if (!isDrop) {
            this.fongoDb.notOkErrorResult("index not found with name [" + name + "]").throwOnError();
        }
    }

    private String nsName() {
        return this.getDB().getName() + "." + this.getName();
    }

    protected synchronized void _dropIndexes() {
        List indexes = this.fongoDb.getCollection(SYSTEM_INDEXES_COLL_NAME).find((DBObject)new BasicDBObject("ns", (Object)this.nsName())).toArray();
        for (DBObject index : indexes) {
            String indexName = index.get("name").toString();
            if (ID_NAME_INDEX.equals(indexName)) continue;
            this.dropIndexes(indexName);
        }
    }

    public void drop() {
        this._idIndex.clear();
        this._dropIndexes();
        this.fongoDb.removeCollection(this);
    }

    private synchronized IndexAbstract searchIndex(DBObject query) {
        IndexAbstract result = null;
        int foundCommon = -1;
        Set queryFields = query.keySet();
        for (IndexAbstract index : this.indexes) {
            if (!index.canHandle(query) || index.getFields().size() <= foundCommon && (result == null || result.isUnique() || !index.isUnique())) continue;
            result = index;
            foundCommon = index.getFields().size();
        }
        LOG.debug("searchIndex() found index {} for fields {}", result, (Object)queryFields);
        return result;
    }

    private synchronized IndexAbstract searchGeoIndex(boolean unique) {
        IndexAbstract result = null;
        for (IndexAbstract index : this.indexes) {
            if (!index.isGeoIndex()) continue;
            if (result != null && unique) {
                this.fongoDb.notOkErrorResult(-5, "more than one 2d index, not sure which to run geoNear on").throwOnError();
            }
            result = index;
            if (unique) continue;
            break;
        }
        LOG.debug("searchGeoIndex() found index {}", result);
        return result;
    }

    private void addToIndexes(DBObject object, DBObject oldObject, WriteConcern concern) {
        for (IndexAbstract indexAbstract : this.indexes) {
            List<List<Object>> error = indexAbstract.checkAddOrUpdate(object, oldObject);
            if (error.isEmpty()) continue;
            if (this.enforceDuplicates(concern)) {
                throw this.fongoDb.duplicateKeyException(11000, "E11000 duplicate key error index: " + this.getFullName() + "." + indexAbstract.getName() + "  dup key : {" + error + " }", oldObject);
            }
            return;
        }
        DBObject idFirst = Util.cloneIdFirst(object);
        try {
            for (IndexAbstract index : this.indexes) {
                if (index.canHandle(object)) {
                    index.addOrUpdate(idFirst, oldObject);
                    continue;
                }
                if (!index.canHandle(oldObject)) continue;
                index.remove(oldObject);
            }
        }
        catch (MongoException mongoException) {
            LOG.info("", (Throwable)mongoException);
            throw this.fongoDb.writeConcernException(mongoException.getCode(), mongoException.getMessage());
        }
        this.fongoDb.addCollection(this);
    }

    private synchronized void removeFromIndexes(DBObject object) {
        for (IndexAbstract index : this.indexes) {
            if (!index.canHandle(object)) continue;
            index.remove(object);
        }
    }

    public synchronized Collection<IndexAbstract> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public synchronized List<DBObject> geoNear(Coordinate near, DBObject query, Number limit, Number maxDistance, boolean spherical) {
        IndexAbstract matchingIndex = this.searchGeoIndex(true);
        if (matchingIndex == null) {
            this.fongoDb.notOkErrorResult(-5, "no geo indices for geoNear").throwOnError();
        }
        LOG.info("geoNear() near:{}, query:{}, limit:{}, maxDistance:{}, spherical:{}, use index:{}", new Object[]{near, query, limit, maxDistance, spherical, matchingIndex.getName()});
        Geometry geometry = GeoUtil.toGeometry(near);
        return ((GeoIndex)matchingIndex).geoNear((DBObject)(query == null ? new BasicDBObject() : query), geometry, limit == null ? 100 : limit.intValue(), spherical);
    }

    public synchronized DBObject text(String search, Number limit, DBObject project) {
        TextSearch ts = new TextSearch(this);
        return ts.findByTextSearch(search, (DBObject)(project == null ? new BasicDBObject() : project), limit == null ? 100 : limit.intValue());
    }

    public long count() {
        return this._idIndex.size();
    }

    public MapReduceOutput mapReduce(MapReduceCommand command) {
        BasicDBObject out = new BasicDBObject();
        if (command.getOutputDB() != null) {
            out.put("db", (Object)command.getOutputDB());
        }
        if (command.getOutputType() != null) {
            out.put(command.getOutputType().name().toLowerCase(), (Object)command.getOutputTarget());
        }
        MapReduce mapReduce = new MapReduce(this.fongoDb.fongo, this, command.getMap(), command.getReduce(), command.getFinalize(), command.getScope(), (DBObject)out, command.getQuery(), command.getSort(), command.getLimit());
        return mapReduce.computeResult();
    }

    public static DBObject dbObject(BsonDocument document) {
        if (document == null) {
            return null;
        }
        return (DBObject)FongoDBCollection.defaultDbObjectCodec().decode((BsonReader)new BsonDocumentReader(document), FongoDBCollection.decoderContext());
    }

    public static <T> List<T> decode(Iterable<DBObject> objects, Decoder<T> resultDecoder) {
        ArrayList<T> list = new ArrayList<T>();
        for (DBObject object : objects) {
            list.add(FongoDBCollection.decode(object, resultDecoder));
        }
        return list;
    }

    public static <T> T decode(DBObject object, Decoder<T> resultDecoder) {
        BsonDocument document = FongoDBCollection.bsonDocument(object);
        return (T)resultDecoder.decode((BsonReader)new BsonDocumentReader(document), FongoDBCollection.decoderContext());
    }

    public static DecoderContext decoderContext() {
        return DecoderContext.builder().build();
    }

    public static EncoderContext encoderContext() {
        return EncoderContext.builder().build();
    }

    public static CodecRegistry defaultCodecRegistry() {
        return MongoClient.getDefaultCodecRegistry();
    }

    public static Codec<DBObject> defaultDbObjectCodec() {
        return FongoDBCollection.defaultCodecRegistry().get(DBObject.class);
    }

    public static <T> Codec<T> codec(Class<T> clazz) {
        return FongoDBCollection.defaultCodecRegistry().get(clazz);
    }

    public static DBObject dbObject(BsonDocument queryDocument, String key) {
        return queryDocument.containsKey((Object)key) ? FongoDBCollection.dbObject(queryDocument.getDocument((Object)key)) : null;
    }

    public static List<DBObject> dbObjects(BsonDocument queryDocument, String key) {
        BsonArray values;
        BsonArray bsonArray = values = queryDocument.containsKey((Object)key) ? queryDocument.getArray((Object)key) : null;
        if (values == null) {
            return null;
        }
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (BsonValue value : values) {
            list.add(FongoDBCollection.dbObject((BsonDocument)value));
        }
        return list;
    }

    public static BsonArray bsonArray(List<?> list) {
        if (list == null) {
            return null;
        }
        BasicDBList dbList = new BasicDBList();
        dbList.addAll(list);
        return FongoDBCollection.bsonDocument((DBObject)new BasicDBObject("array", (Object)dbList)).getArray((Object)"array");
    }

    public static BsonDocument bsonDocument(DBObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        BsonDocument bsonDocument = new BsonDocument();
        FongoDBCollection.defaultDbObjectCodec().encode((BsonWriter)new BsonDocumentWriter(bsonDocument), (Object)dbObject, FongoDBCollection.encoderContext());
        return bsonDocument;
    }

    public static List<BsonDocument> bsonDocuments(Iterable<DBObject> dbObjects) {
        if (dbObjects == null) {
            return null;
        }
        ArrayList<BsonDocument> list = new ArrayList<BsonDocument>();
        for (DBObject dbObject : dbObjects) {
            list.add(FongoDBCollection.bsonDocument(dbObject));
        }
        return list;
    }

    static BulkWriteResult translateBulkWriteResult(com.mongodb.bulk.BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            Integer modifiedCount = bulkWriteResult.isModifiedCountAvailable() ? Integer.valueOf(bulkWriteResult.getModifiedCount()) : null;
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), modifiedCount, FongoDBCollection.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    public static List<com.mongodb.BulkWriteUpsert> translateBulkWriteUpserts(List<BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<com.mongodb.BulkWriteUpsert> retVal = new ArrayList<com.mongodb.BulkWriteUpsert>(upserts.size());
        for (BulkWriteUpsert cur : upserts) {
            retVal.add(new com.mongodb.BulkWriteUpsert(cur.getIndex(), FongoDBCollection.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    public static List<BulkWriteUpsert> translateBulkWriteUpsertsToNew(List<com.mongodb.BulkWriteUpsert> upserts, Decoder<BsonValue> decoder) {
        ArrayList<BulkWriteUpsert> retVal = new ArrayList<BulkWriteUpsert>(upserts.size());
        for (com.mongodb.BulkWriteUpsert cur : upserts) {
            BsonDocument document = FongoDBCollection.bsonDocument((DBObject)new BasicDBObject("_id", cur.getId()));
            retVal.add(new BulkWriteUpsert(cur.getIndex(), document.get((Object)"_id")));
        }
        return retVal;
    }

    public static Object getUpsertedId(BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return ((DBObject)decoder.decode((BsonReader)new BsonDocumentReader(new BsonDocument("_id", cur.getId())), FongoDBCollection.decoderContext())).get("_id");
    }

    public static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(FongoDBCollection.translateBulkWriteResult(e.getWriteResult(), decoder), FongoDBCollection.translateWriteErrors(e.getWriteErrors()), FongoDBCollection.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    public static WriteConcernError translateWriteConcernError(com.mongodb.bulk.WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), FongoDBCollection.dbObject(writeConcernError.getDetails()));
    }

    public static List<com.mongodb.BulkWriteError> translateWriteErrors(List<BulkWriteError> errors) {
        ArrayList<com.mongodb.BulkWriteError> retVal = new ArrayList<com.mongodb.BulkWriteError>(errors.size());
        for (BulkWriteError cur : errors) {
            retVal.add(new com.mongodb.BulkWriteError(cur.getCode(), cur.getMessage(), FongoDBCollection.dbObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private Filter buildFilter(DBObject q) {
        try {
            return this.expressionParser.buildFilter(q);
        }
        catch (FongoException e) {
            if (e.getCode() != null) {
                this.fongoDb.notOkErrorResult(e.getCode(), e.getMessage()).throwOnError();
            }
            throw e;
        }
    }
}

