/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.index;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.index.IndexedList;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.FongoDBCollection;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bson.types.Binary;

public abstract class IndexAbstract<T extends DBObject> {
    final String geoIndex;
    final ExpressionParser expressionParser = new ExpressionParser();
    final Map<T, IndexedList<T>> mapValues;
    private final String name;
    private final DBObject keys;
    private final Set<String> fields;
    private final boolean unique;
    private final boolean sparse;
    int lookupCount = 0;

    IndexAbstract(String name, DBObject keys, boolean unique, Map<T, IndexedList<T>> mapValues, String geoIndex, boolean sparse) throws MongoException {
        this.name = name;
        this.fields = Collections.unmodifiableSet(keys.keySet());
        this.keys = this.prepareKeys(keys);
        this.unique = unique;
        this.mapValues = mapValues;
        this.geoIndex = geoIndex;
        this.sparse = sparse;
        for (Object value : keys.toMap().values()) {
            if (value instanceof String || value instanceof Number) continue;
            throw new MongoException(67, "bad index key pattern : " + keys);
        }
    }

    static boolean isAsc(DBObject keys) {
        Object value = keys.toMap().values().iterator().next();
        return value instanceof Number && ((Number)value).intValue() >= 1;
    }

    private DBObject prepareKeys(DBObject keys) {
        DBObject nKeys = Util.clone(keys);
        if (!nKeys.containsField("_id")) {
            boolean exclude = true;
            for (String key : nKeys.keySet()) {
                if (!key.startsWith("_id")) continue;
                exclude = false;
                break;
            }
            if (exclude) {
                nKeys.put("_id", (Object)0);
            }
        }
        for (Map.Entry<String, Object> entry : Util.entrySet(keys)) {
            if (entry.getValue().equals("2d") || entry.getValue().equals("2dsphere")) {
                nKeys.put(entry.getKey(), (Object)1);
            }
            if (!(entry.getValue() instanceof Number) || ((Number)entry.getValue()).longValue() >= 0L) continue;
            nKeys.put(entry.getKey(), (Object)1);
        }
        return nKeys;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public boolean isGeoIndex() {
        return this.geoIndex != null;
    }

    public DBObject getKeys() {
        return this.keys;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public List<List<Object>> addOrUpdate(T object, T oldObject) {
        if (oldObject != null) {
            this.remove(oldObject);
        }
        T key = this.getKeyFor((DBObject)object);
        if (this.sparse && this.isPartialKey(key)) {
            return Collections.emptyList();
        }
        if (this.unique) {
            if (this.mapValues.containsKey(key)) {
                return this.extractFields((DBObject)object, key.keySet());
            }
            T toAdd = this.embedded((DBObject)object);
            this.mapValues.put(key, new IndexedList<T>(Collections.singletonList(toAdd)));
        } else {
            IndexedList<Object> values = this.mapValues.get(key);
            if (values == null) {
                values = new IndexedList(new ArrayList());
                this.mapValues.put(key, values);
            }
            T toAdd = this.embedded((DBObject)object);
            values.add(toAdd);
        }
        return Collections.emptyList();
    }

    private boolean isPartialKey(T key) {
        Set<String> keyProjections = this.generateProjections(key, "");
        return !this.getFields().equals(keyProjections);
    }

    private Set<String> generateProjections(T object, String parentPath) {
        TreeSet<String> rval = new TreeSet<String>();
        for (String objectKey : object.keySet()) {
            Object value = object.get(objectKey);
            if (value instanceof List) {
                List valueList = (List)value;
                for (Object listItem : valueList) {
                    if (listItem instanceof DBObject) {
                        rval.addAll(this.generateProjections((DBObject)listItem, parentPath + objectKey + "."));
                        continue;
                    }
                    rval.add(parentPath + objectKey);
                }
                continue;
            }
            if (value instanceof DBObject) {
                rval.addAll(this.generateProjections((DBObject)value, parentPath + objectKey + "."));
                continue;
            }
            rval.add(parentPath + objectKey);
        }
        return rval;
    }

    public abstract T embedded(DBObject var1);

    public List<List<Object>> checkAddOrUpdate(T object, T oldObject) {
        T key;
        IndexedList<T> objects;
        if (this.unique && (objects = this.mapValues.get(key = this.getKeyFor((DBObject)object))) != null && !objects.contains(oldObject)) {
            List<List<Object>> fieldsForIndex = this.extractFields((DBObject)object, (Collection<String>)this.getFields());
            return fieldsForIndex;
        }
        return Collections.emptyList();
    }

    public void remove(T object) {
        T key = this.getKeyFor((DBObject)object);
        IndexedList<T> values = this.mapValues.get(key);
        if (values != null) {
            if (values.size() == 1) {
                this.mapValues.remove(key);
            } else {
                values.remove(object);
            }
        }
    }

    public List<List<Object>> addAll(Iterable<T> objects) {
        for (DBObject object : objects) {
            List<List<Object>> nonUnique;
            if (!this.canHandle(object) || (nonUnique = this.addOrUpdate(object, null)).isEmpty()) continue;
            return nonUnique;
        }
        return Collections.emptyList();
    }

    public List<T> get(DBObject query) {
        if (!this.unique) {
            throw new IllegalStateException("get is only for unique index");
        }
        ++this.lookupCount;
        T key = this.getKeyFor(query);
        IndexedList<T> result = this.mapValues.get(key);
        if (result != null) {
            return result.getElements();
        }
        return null;
    }

    public Collection<T> retrieveObjects(DBObject query) {
        List<T> result;
        Object key;
        if (this.unique && query.keySet().size() == 1 && !ExpressionParser.isDbObject(key = query.toMap().values().iterator().next()) && !(key instanceof Binary) && !(key instanceof byte[]) && (result = this.get(query)) != null) {
            return result;
        }
        ++this.lookupCount;
        Filter filterKey = this.expressionParser.buildFilter(query, this.getFields());
        Filter filter = this.expressionParser.buildFilter(query);
        ArrayList<DBObject> result2 = new ArrayList<DBObject>();
        for (Map.Entry<T, IndexedList<T>> entry : this.mapValues.entrySet()) {
            if (!filterKey.apply((DBObject)entry.getKey())) continue;
            for (DBObject object : entry.getValue().getElements()) {
                if (!filter.apply(object)) continue;
                result2.add(object);
            }
        }
        return result2;
    }

    public long getLookupCount() {
        return this.lookupCount;
    }

    public int size() {
        int size = 0;
        if (this.unique) {
            size = this.mapValues.size();
        } else {
            for (Map.Entry<T, IndexedList<T>> entry : this.mapValues.entrySet()) {
                size += entry.getValue().size();
            }
        }
        return size;
    }

    public List<DBObject> values() {
        ArrayList<DBObject> values = new ArrayList<DBObject>(this.mapValues.size() * 10);
        for (IndexedList<T> objects : this.mapValues.values()) {
            values.addAll(objects.getElements());
        }
        return values;
    }

    public void clear() {
        this.mapValues.clear();
    }

    public boolean canHandle(DBObject queryFields) {
        if (queryFields == null) {
            return false;
        }
        for (String field : this.fields) {
            Object o = queryFields.get(field);
            if (o == null && !this.keyEmbeddedFieldMatch(field, queryFields)) {
                return false;
            }
            if (!ExpressionParser.isDbObject(o) || !ExpressionParser.toDbObject(o).containsField("$exists")) continue;
            return false;
        }
        return true;
    }

    private boolean keyEmbeddedFieldMatch(String field, DBObject queryFields) {
        String[] fieldParts = field.split("\\.");
        if (fieldParts.length == 0) {
            return false;
        }
        DBObject searchQueryFields = queryFields;
        int count = 0;
        for (String fieldPart : fieldParts) {
            ++count;
            if (searchQueryFields instanceof BasicDBList) {
                return true;
            }
            if (!searchQueryFields.containsField(fieldPart) || searchQueryFields.get(fieldPart) == null) {
                return false;
            }
            if (!ExpressionParser.isDbObject(searchQueryFields.get(fieldPart))) continue;
            searchQueryFields = ExpressionParser.toDbObject(searchQueryFields.get(fieldPart));
        }
        return fieldParts.length == count;
    }

    public String toString() {
        return "Index{name='" + this.name + '\'' + '}';
    }

    T getKeyFor(DBObject object) {
        DBObject applyProjections = FongoDBCollection.applyProjections(object, this.keys);
        return (T)this.pruneEmptyListObjects(applyProjections);
    }

    private DBObject pruneEmptyListObjects(DBObject projectedObject) {
        BasicDBObject ret = new BasicDBObject();
        for (String projectionKey : projectedObject.keySet()) {
            Object projectedValue = projectedObject.get(projectionKey);
            if (projectedValue instanceof List) {
                BasicDBList prunedList = this.pruneList((List)projectedValue);
                ret.put((Object)projectionKey, (Object)prunedList);
                continue;
            }
            if (ExpressionParser.isDbObject(projectedValue)) {
                ret.put((Object)projectionKey, (Object)this.pruneEmptyListObjects((DBObject)projectedValue));
                continue;
            }
            ret.put((Object)projectionKey, projectedValue);
        }
        return ret;
    }

    private BasicDBList pruneList(List inList) {
        BasicDBList ret = new BasicDBList();
        for (Object listItem : inList) {
            if (listItem instanceof List) {
                ret.add((Object)((List)listItem));
                continue;
            }
            if (listItem instanceof DBObject) {
                if (((DBObject)listItem).keySet().isEmpty()) continue;
                ret.add(listItem);
                continue;
            }
            ret.add(listItem);
        }
        return ret;
    }

    private List<List<Object>> extractFields(DBObject dbObject, Collection<String> fields) {
        ArrayList<List<Object>> fieldValue = new ArrayList<List<Object>>();
        for (String field : fields) {
            List<Object> embeddedValues = this.expressionParser.getEmbeddedValues(field, dbObject);
            fieldValue.add(embeddedValues);
        }
        return fieldValue;
    }
}

