/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceRoot
extends PipelineKeyword {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceRoot.class);
    public static ReplaceRoot INSTANCE = new ReplaceRoot();

    @Override
    public DBCollection apply(DB originalDB, DBCollection parentColl, DBObject replaceRootQuery) {
        LOGGER.trace(">>>> applying $replaceRoot pipeline operation");
        DBObject newRoot = ExpressionParser.toDbObject(replaceRootQuery.get(this.getKeyword()));
        LOGGER.trace("<<<< applying $replaceRoot pipeline operation");
        List<DBObject> dbObjects = this.replaceRootFromDocument(parentColl, newRoot);
        return this.dropAndInsert(parentColl, dbObjects);
    }

    private List<DBObject> replaceRootFromDocument(DBCollection parentColl, DBObject replaceRootExpr) {
        Object replaceRootExprValue = replaceRootExpr.get("newRoot");
        ReplaceRoot.validateNull(replaceRootExprValue, "newRoot expression cannot be null");
        ArrayList<DBObject> retval = new ArrayList<DBObject>();
        if (replaceRootExprValue instanceof String) {
            String newRootValue = (String)replaceRootExprValue;
            int index = 0;
            ReplaceRoot.validateTrue(newRootValue.charAt(0) == '$', "Field path expression for newRoot must start with $");
            newRootValue = newRootValue.substring(1);
            DBCursor cursor = parentColl.find();
            while (cursor.hasNext()) {
                DBObject object = cursor.next();
                Object embeddedDoc = object.get(newRootValue);
                ReplaceRoot.validateNull(embeddedDoc, newRootValue + " is missing in collection at index " + index);
                ReplaceRoot.validateTrue(DBObject.class.isAssignableFrom(embeddedDoc.getClass()), "Embedded value must evaluate to document at " + index);
                ++index;
                retval.add((DBObject)embeddedDoc);
            }
            return retval;
        }
        DBObject newRootExpr = ExpressionParser.toDbObject(replaceRootExprValue);
        String projectionExpr = "{$project :".concat(newRootExpr.toString()).concat("}");
        DBObject projection = ExpressionParser.toDbObject(BasicDBObject.parse((String)projectionExpr));
        AggregationOutput aggregationOutput = parentColl.aggregate(Arrays.asList(projection));
        Iterable results = aggregationOutput.results();
        ReplaceRoot.validateNull(results, "Expression for new root resulted in a null object");
        for (DBObject result : results) {
            retval.add(result);
        }
        return retval;
    }

    @Override
    public String getKeyword() {
        return "$replaceRoot";
    }
}

