/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.async;

import com.github.fakemongo.async.FongoAsync;
import com.github.fakemongo.async.FongoAsyncConnection;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.session.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FongoAsyncConnectionSource
implements AsyncConnectionSource {
    private static final Logger LOG = LoggerFactory.getLogger(FongoAsyncConnectionSource.class);
    private final FongoAsync fongoAsync;

    public FongoAsyncConnectionSource(FongoAsync fongoAsync) {
        this.fongoAsync = fongoAsync;
    }

    public ServerDescription getServerDescription() {
        return ServerDescription.builder().address(this.fongoAsync.getServerAddress()).state(ServerConnectionState.CONNECTED).version(this.fongoAsync.getServerVersion()).build();
    }

    public SessionContext getSessionContext() {
        return NoOpSessionContext.INSTANCE;
    }

    public void getConnection(SingleResultCallback<AsyncConnection> callback) {
        callback.onResult((Object)new FongoAsyncConnection(this.fongoAsync), null);
    }

    public AsyncConnectionSource retain() {
        return this;
    }

    public int getCount() {
        return 0;
    }

    public void release() {
    }
}

