/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.async;

import com.github.fakemongo.FongoConnection;
import com.github.fakemongo.async.FongoAsync;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerVersion;
import com.mongodb.connection.SplittablePayload;
import com.mongodb.session.SessionContext;
import java.util.List;
import java.util.concurrent.Callable;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FongoAsyncConnection
implements AsyncConnection {
    private static final Logger LOG = LoggerFactory.getLogger(FongoAsyncConnection.class);
    private final FongoAsync fongoAsync;
    private final FongoConnection fongoConnection;
    private final ConnectionDescription connectionDescription;

    public FongoAsyncConnection(final FongoAsync fongoAsync) {
        this.fongoAsync = fongoAsync;
        this.connectionDescription = new ConnectionDescription(new ServerId(new ClusterId(), fongoAsync.getServerAddress())){

            public ServerVersion getServerVersion() {
                return fongoAsync.getServerVersion();
            }
        };
        this.fongoConnection = new FongoConnection(fongoAsync.getFongo());
    }

    public FongoAsyncConnection retain() {
        LOG.debug("retain()");
        return this;
    }

    public ConnectionDescription getDescription() {
        return this.connectionDescription;
    }

    public void insertAsync(final MongoNamespace namespace, final boolean ordered, final InsertRequest insertRequest, SingleResultCallback<WriteConcernResult> callback) {
        this.asyncResult(new Callable<WriteConcernResult>(){

            @Override
            public WriteConcernResult call() {
                return FongoAsyncConnection.this.fongoConnection.insert(namespace, ordered, insertRequest);
            }
        }, callback);
    }

    public void updateAsync(final MongoNamespace namespace, final boolean ordered, final UpdateRequest updateRequest, SingleResultCallback<WriteConcernResult> callback) {
        this.asyncResult(new Callable<WriteConcernResult>(){

            @Override
            public WriteConcernResult call() {
                return FongoAsyncConnection.this.fongoConnection.update(namespace, ordered, updateRequest);
            }
        }, callback);
    }

    public void deleteAsync(final MongoNamespace namespace, final boolean ordered, final DeleteRequest deleteRequest, SingleResultCallback<WriteConcernResult> callback) {
        this.asyncResult(new Callable<WriteConcernResult>(){

            @Override
            public WriteConcernResult call() {
                return FongoAsyncConnection.this.fongoConnection.delete(namespace, ordered, deleteRequest);
            }
        }, callback);
    }

    public void insertAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final List<InsertRequest> inserts, SingleResultCallback<WriteConcernResult> callback) {
        this.asyncResult(new Callable<WriteConcernResult>(){

            @Override
            public WriteConcernResult call() {
                return FongoAsyncConnection.this.fongoConnection.insert(namespace, ordered, writeConcern, inserts);
            }
        }, callback);
    }

    public void updateAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final List<UpdateRequest> updates, SingleResultCallback<WriteConcernResult> callback) {
        this.asyncResult(new Callable<WriteConcernResult>(){

            @Override
            public WriteConcernResult call() {
                return FongoAsyncConnection.this.fongoConnection.update(namespace, ordered, writeConcern, updates);
            }
        }, callback);
    }

    public void deleteAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final List<DeleteRequest> deletes, SingleResultCallback<WriteConcernResult> callback) {
        this.asyncResult(new Callable<WriteConcernResult>(){

            @Override
            public WriteConcernResult call() {
                return FongoAsyncConnection.this.fongoConnection.delete(namespace, ordered, writeConcern, deletes);
            }
        }, callback);
    }

    public void insertCommandAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final List<InsertRequest> inserts, SingleResultCallback<BulkWriteResult> callback) {
        this.asyncResult(new Callable<BulkWriteResult>(){

            @Override
            public BulkWriteResult call() {
                return FongoAsyncConnection.this.fongoConnection.insertCommand(namespace, ordered, writeConcern, inserts);
            }
        }, callback);
    }

    public void insertCommandAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final Boolean bypassDocumentValidation, final List<InsertRequest> inserts, SingleResultCallback<BulkWriteResult> callback) {
        this.asyncResult(new Callable<BulkWriteResult>(){

            @Override
            public BulkWriteResult call() {
                return FongoAsyncConnection.this.fongoConnection.insertCommand(namespace, ordered, writeConcern, bypassDocumentValidation, inserts);
            }
        }, callback);
    }

    public void updateCommandAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final List<UpdateRequest> updates, SingleResultCallback<BulkWriteResult> callback) {
        this.asyncResult(new Callable<BulkWriteResult>(){

            @Override
            public BulkWriteResult call() {
                return FongoAsyncConnection.this.fongoConnection.updateCommand(namespace, ordered, writeConcern, updates);
            }
        }, callback);
    }

    public void updateCommandAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final Boolean bypassDocumentValidation, final List<UpdateRequest> updates, SingleResultCallback<BulkWriteResult> callback) {
        this.asyncResult(new Callable<BulkWriteResult>(){

            @Override
            public BulkWriteResult call() {
                return FongoAsyncConnection.this.fongoConnection.updateCommand(namespace, ordered, writeConcern, bypassDocumentValidation, updates);
            }
        }, callback);
    }

    public void deleteCommandAsync(final MongoNamespace namespace, final boolean ordered, final WriteConcern writeConcern, final List<DeleteRequest> deletes, SingleResultCallback<BulkWriteResult> callback) {
        this.asyncResult(new Callable<BulkWriteResult>(){

            @Override
            public BulkWriteResult call() {
                return FongoAsyncConnection.this.fongoConnection.deleteCommand(namespace, ordered, writeConcern, deletes);
            }
        }, callback);
    }

    public <T> void commandAsync(final String database, final BsonDocument command, final boolean slaveOk, final FieldNameValidator fieldNameValidator, final Decoder<T> commandResultDecoder, SingleResultCallback<T> callback) {
        LOG.info("commandAsync() command:{}", (Object)command);
        this.asyncResult(new Callable<T>(){

            @Override
            public T call() {
                return FongoAsyncConnection.this.fongoConnection.command(database, command, slaveOk, fieldNameValidator, commandResultDecoder);
            }
        }, callback);
    }

    public <T> void commandAsync(final String database, final BsonDocument command, final FieldNameValidator fieldNameValidator, final ReadPreference readPreference, final Decoder<T> commandResultDecoder, SessionContext sessionContext, SingleResultCallback<T> callback) {
        LOG.info("commandAsync() command:{}", (Object)command);
        this.asyncResult(new Callable<T>(){

            @Override
            public T call() {
                return FongoAsyncConnection.this.fongoConnection.command(database, command, readPreference == null ? false : readPreference.isSlaveOk(), fieldNameValidator, commandResultDecoder);
            }
        }, callback);
    }

    public <T> void commandAsync(final String database, final BsonDocument command, final FieldNameValidator commandFieldNameValidator, final ReadPreference readPreference, final Decoder<T> commandResultDecoder, final SessionContext sessionContext, boolean responseExpected, final SplittablePayload payload, final FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
        LOG.info("commandAsync() command:{}", (Object)command);
        this.asyncResult(new Callable<T>(){

            @Override
            public T call() {
                return FongoAsyncConnection.this.fongoConnection.command(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, sessionContext, true, payload, payloadFieldNameValidator);
            }
        }, callback);
    }

    public <T> void queryAsync(final MongoNamespace namespace, final BsonDocument queryDocument, final BsonDocument fields, final int numberToReturn, final int skip, final boolean slaveOk, final boolean tailableCursor, final boolean awaitData, final boolean noCursorTimeout, final boolean partial, final boolean oplogReplay, final Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        this.asyncResult(new Callable<QueryResult<T>>(){

            @Override
            public QueryResult<T> call() {
                return FongoAsyncConnection.this.fongoConnection.query(namespace, queryDocument, fields, numberToReturn, skip, slaveOk, tailableCursor, awaitData, noCursorTimeout, partial, oplogReplay, resultDecoder);
            }
        }, callback);
    }

    public <T> void queryAsync(final MongoNamespace namespace, final BsonDocument queryDocument, final BsonDocument fields, final int skip, final int limit, final int batchSize, final boolean slaveOk, final boolean tailableCursor, final boolean awaitData, final boolean noCursorTimeout, final boolean partial, final boolean oplogReplay, final Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        LOG.info("queryAsync {}", (Object)queryDocument);
        this.asyncResult(new Callable<QueryResult<T>>(){

            @Override
            public QueryResult<T> call() {
                return FongoAsyncConnection.this.fongoConnection.query(namespace, queryDocument, fields, skip, limit, batchSize, slaveOk, tailableCursor, awaitData, noCursorTimeout, partial, oplogReplay, resultDecoder);
            }
        }, callback);
    }

    public <T> void getMoreAsync(final MongoNamespace namespace, final long cursorId, final int numberToReturn, final Decoder<T> resultDecoder, SingleResultCallback<QueryResult<T>> callback) {
        this.asyncResult(new Callable<QueryResult<T>>(){

            @Override
            public QueryResult<T> call() {
                return FongoAsyncConnection.this.fongoConnection.getMore(namespace, cursorId, numberToReturn, resultDecoder);
            }
        }, callback);
    }

    public void killCursorAsync(final List<Long> cursors, SingleResultCallback<Void> callback) {
        this.asyncResult(new Callable<Void>(){

            @Override
            public Void call() {
                FongoAsyncConnection.this.fongoConnection.killCursor(cursors);
                return null;
            }
        }, callback);
    }

    public void killCursorAsync(final MongoNamespace namespace, final List<Long> cursors, SingleResultCallback<Void> callback) {
        this.asyncResult(new Callable<Void>(){

            @Override
            public Void call() {
                FongoAsyncConnection.this.fongoConnection.killCursor(namespace, cursors);
                return null;
            }
        }, callback);
    }

    private <T> void asyncResult(Callable<T> callable, SingleResultCallback<T> callback) {
        try {
            callback.onResult(callable.call(), null);
        }
        catch (Throwable throwable) {
            callback.onResult(null, throwable);
        }
    }

    public int getCount() {
        LOG.info("getCount()");
        return 0;
    }

    public void release() {
        LOG.debug("release()");
    }
}

