/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeUtils {
    public static final String BIGINT = "BIGINT";
    public static final String BINARY = "BINARY";
    public static final String BIT = "BIT";
    public static final String BLOB = "BLOB";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String CHAR = "CHAR";
    public static final String CLOB = "CLOB";
    public static final String DATE = "DATE";
    public static final String DECIMAL = "DECIMAL";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String INTEGER = "INTEGER";
    public static final String INT = "INT";
    public static final String JAVA_OBJECT = "JAVA_OBJECT";
    public static final String LONGNVARCHAR = "LONGNVARCHAR";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String NCHAR = "NCHAR";
    public static final String NCLOB = "NCLOB";
    public static final String NUMERIC = "NUMERIC";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String UNKNOW = "UNKNOW";
    public static final String REAL = "REAL";
    public static final String SMALLINT = "SMALLINT";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TINYINT = "TINYINT";
    public static final String VARBINARY = "VARBINARY";
    public static final String VARCHAR = "VARCHAR";
    private static final Map<Class<?>, Type> JAVA_TO_TYPE_MAP = new HashMap();
    private static final Map<Type, Class<?>> TYPE_TO_JAVA_MAP = new HashMap();

    public static boolean canMapToDialectType(Class<?> clazz) {
        return JAVA_TO_TYPE_MAP.containsKey(clazz);
    }

    public static Class<?> dialectTypeToJavaType(Type type) {
        return TYPE_TO_JAVA_MAP.get((Object)type);
    }

    public static Type javaType2DialectType(Class<?> clazz) {
        return JAVA_TO_TYPE_MAP.get(clazz);
    }

    public static Type colDef2DialectType(String columnDefination) {
        String columnDef = StrUtils.substringBefore(columnDefination, "(");
        if (BIGINT.equalsIgnoreCase(columnDef)) {
            return Type.BIGINT;
        }
        if (BINARY.equalsIgnoreCase(columnDef)) {
            return Type.BINARY;
        }
        if (BIT.equalsIgnoreCase(columnDef)) {
            return Type.BIT;
        }
        if (BLOB.equalsIgnoreCase(columnDef)) {
            return Type.BLOB;
        }
        if (BOOLEAN.equalsIgnoreCase(columnDef)) {
            return Type.BOOLEAN;
        }
        if (CHAR.equalsIgnoreCase(columnDef)) {
            return Type.CHAR;
        }
        if (CLOB.equalsIgnoreCase(columnDef)) {
            return Type.CLOB;
        }
        if (DATE.equalsIgnoreCase(columnDef)) {
            return Type.DATE;
        }
        if (DECIMAL.equalsIgnoreCase(columnDef)) {
            return Type.DECIMAL;
        }
        if (DOUBLE.equalsIgnoreCase(columnDef)) {
            return Type.DOUBLE;
        }
        if (FLOAT.equalsIgnoreCase(columnDef)) {
            return Type.FLOAT;
        }
        if (INTEGER.equalsIgnoreCase(columnDef)) {
            return Type.INTEGER;
        }
        if (INT.equalsIgnoreCase(columnDef)) {
            return Type.INTEGER;
        }
        if (JAVA_OBJECT.equalsIgnoreCase(columnDef)) {
            return Type.JAVA_OBJECT;
        }
        if (LONGNVARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.LONGNVARCHAR;
        }
        if (LONGVARBINARY.equalsIgnoreCase(columnDef)) {
            return Type.LONGVARBINARY;
        }
        if (LONGVARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.LONGVARCHAR;
        }
        if (NCHAR.equalsIgnoreCase(columnDef)) {
            return Type.NCHAR;
        }
        if (NCLOB.equalsIgnoreCase(columnDef)) {
            return Type.NCLOB;
        }
        if (NUMERIC.equalsIgnoreCase(columnDef)) {
            return Type.NUMERIC;
        }
        if (NVARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.NVARCHAR;
        }
        if (UNKNOW.equalsIgnoreCase(columnDef)) {
            return Type.UNKNOW;
        }
        if (REAL.equalsIgnoreCase(columnDef)) {
            return Type.REAL;
        }
        if (SMALLINT.equalsIgnoreCase(columnDef)) {
            return Type.SMALLINT;
        }
        if (TIME.equalsIgnoreCase(columnDef)) {
            return Type.TIME;
        }
        if (TIMESTAMP.equalsIgnoreCase(columnDef)) {
            return Type.TIMESTAMP;
        }
        if (TINYINT.equalsIgnoreCase(columnDef)) {
            return Type.TINYINT;
        }
        if (VARBINARY.equalsIgnoreCase(columnDef)) {
            return Type.VARBINARY;
        }
        if (VARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.VARCHAR;
        }
        if ("TEXT".equalsIgnoreCase(columnDef)) {
            return Type.VARCHAR;
        }
        throw new DialectException("'" + columnDef + "' can not be map to a dialect type");
    }

    public static Type javaSqlTypeToDialectType(int javaSqlType) {
        switch (javaSqlType) {
            case -7: {
                return Type.BIT;
            }
            case -6: {
                return Type.TINYINT;
            }
            case 5: {
                return Type.SMALLINT;
            }
            case 4: {
                return Type.INTEGER;
            }
            case -5: {
                return Type.BIGINT;
            }
            case 6: {
                return Type.FLOAT;
            }
            case 7: {
                return Type.REAL;
            }
            case 8: {
                return Type.DOUBLE;
            }
            case 2: {
                return Type.NUMERIC;
            }
            case 3: {
                return Type.DECIMAL;
            }
            case 1: {
                return Type.CHAR;
            }
            case 12: {
                return Type.VARCHAR;
            }
            case -1: {
                return Type.LONGVARCHAR;
            }
            case 91: {
                return Type.DATE;
            }
            case 92: {
                return Type.TIME;
            }
            case 93: {
                return Type.TIMESTAMP;
            }
            case -2: {
                return Type.BINARY;
            }
            case -3: {
                return Type.VARBINARY;
            }
            case -4: {
                return Type.LONGVARBINARY;
            }
            case 1111: {
                return Type.UNKNOW;
            }
            case 2000: {
                return Type.JAVA_OBJECT;
            }
            case 2004: {
                return Type.BLOB;
            }
            case 2005: {
                return Type.CLOB;
            }
            case 16: {
                return Type.BOOLEAN;
            }
            case -15: {
                return Type.NCHAR;
            }
            case -9: {
                return Type.NVARCHAR;
            }
            case -16: {
                return Type.LONGNVARCHAR;
            }
            case 2011: {
                return Type.NCLOB;
            }
        }
        throw new DialectException("Unsupported java.sql.Types:" + javaSqlType);
    }

    static {
        JAVA_TO_TYPE_MAP.put(BigDecimal.class, Type.NUMERIC);
        JAVA_TO_TYPE_MAP.put(BigInteger.class, Type.BIGINT);
        JAVA_TO_TYPE_MAP.put(Boolean.class, Type.BOOLEAN);
        JAVA_TO_TYPE_MAP.put(Boolean.TYPE, Type.BOOLEAN);
        JAVA_TO_TYPE_MAP.put(Byte.class, Type.TINYINT);
        JAVA_TO_TYPE_MAP.put(Byte.TYPE, Type.TINYINT);
        JAVA_TO_TYPE_MAP.put(Character.class, Type.CHAR);
        JAVA_TO_TYPE_MAP.put(Character.TYPE, Type.CHAR);
        JAVA_TO_TYPE_MAP.put(Double.class, Type.DOUBLE);
        JAVA_TO_TYPE_MAP.put(Double.TYPE, Type.DOUBLE);
        JAVA_TO_TYPE_MAP.put(Float.class, Type.FLOAT);
        JAVA_TO_TYPE_MAP.put(Float.TYPE, Type.FLOAT);
        JAVA_TO_TYPE_MAP.put(Integer.class, Type.INTEGER);
        JAVA_TO_TYPE_MAP.put(Integer.TYPE, Type.INTEGER);
        JAVA_TO_TYPE_MAP.put(Long.class, Type.BIGINT);
        JAVA_TO_TYPE_MAP.put(Long.TYPE, Type.BIGINT);
        JAVA_TO_TYPE_MAP.put(Short.class, Type.SMALLINT);
        JAVA_TO_TYPE_MAP.put(Short.TYPE, Type.SMALLINT);
        JAVA_TO_TYPE_MAP.put(String.class, Type.VARCHAR);
        JAVA_TO_TYPE_MAP.put(Character.TYPE, Type.VARCHAR);
        JAVA_TO_TYPE_MAP.put(Clob.class, Type.CLOB);
        JAVA_TO_TYPE_MAP.put(Blob.class, Type.BLOB);
        JAVA_TO_TYPE_MAP.put(java.util.Date.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(Date.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(Calendar.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(Time.class, Type.TIME);
        JAVA_TO_TYPE_MAP.put(Timestamp.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(LocalDate.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(LocalTime.class, Type.TIME);
        JAVA_TO_TYPE_MAP.put(OffsetTime.class, Type.TIME);
        JAVA_TO_TYPE_MAP.put(Instant.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(LocalDateTime.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(OffsetDateTime.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(ZonedDateTime.class, Type.TIMESTAMP);
        TYPE_TO_JAVA_MAP.put(Type.NUMERIC, BigDecimal.class);
        TYPE_TO_JAVA_MAP.put(Type.BIGINT, Long.class);
        TYPE_TO_JAVA_MAP.put(Type.BOOLEAN, Boolean.class);
        TYPE_TO_JAVA_MAP.put(Type.TINYINT, Byte.class);
        TYPE_TO_JAVA_MAP.put(Type.SMALLINT, Short.class);
        TYPE_TO_JAVA_MAP.put(Type.VARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.BINARY, Blob.class);
        TYPE_TO_JAVA_MAP.put(Type.BIT, Boolean.class);
        TYPE_TO_JAVA_MAP.put(Type.BLOB, Blob.class);
        TYPE_TO_JAVA_MAP.put(Type.CHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.CLOB, Clob.class);
        TYPE_TO_JAVA_MAP.put(Type.DECIMAL, BigDecimal.class);
        TYPE_TO_JAVA_MAP.put(Type.DOUBLE, Double.class);
        TYPE_TO_JAVA_MAP.put(Type.FLOAT, Float.class);
        TYPE_TO_JAVA_MAP.put(Type.INTEGER, Integer.class);
        TYPE_TO_JAVA_MAP.put(Type.JAVA_OBJECT, Object.class);
        TYPE_TO_JAVA_MAP.put(Type.LONGNVARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.LONGVARBINARY, String.class);
        TYPE_TO_JAVA_MAP.put(Type.LONGVARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.NCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.NCLOB, Clob.class);
        TYPE_TO_JAVA_MAP.put(Type.NVARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.UNKNOW, Object.class);
        TYPE_TO_JAVA_MAP.put(Type.REAL, Float.class);
        TYPE_TO_JAVA_MAP.put(Type.VARBINARY, Blob.class);
        TYPE_TO_JAVA_MAP.put(Type.DATE, java.util.Date.class);
        TYPE_TO_JAVA_MAP.put(Type.TIME, Time.class);
        TYPE_TO_JAVA_MAP.put(Type.TIMESTAMP, Timestamp.class);
    }
}

