/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jlogs;

import com.github.drinkjava2.jlogs.Log;
import java.lang.reflect.Method;

public class SimpleSLF4JLog
implements Log {
    private Object logger;
    private Method info;
    private Method debug;
    private Method warn;
    private Method warnExp;
    private Method error;
    private Method errorExp;

    public SimpleSLF4JLog(Class<?> targetClass) {
        try {
            Class<?> logFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            Method method = logFactoryClass.getMethod("getLogger", Class.class);
            this.logger = method.invoke(logFactoryClass, targetClass);
            this.debug = this.logger.getClass().getMethod("debug", String.class);
            this.info = this.logger.getClass().getMethod("info", String.class);
            this.warn = this.logger.getClass().getMethod("warn", String.class);
            this.error = this.logger.getClass().getMethod("error", String.class);
            this.warnExp = this.logger.getClass().getMethod("warn", String.class, Throwable.class);
            this.errorExp = this.logger.getClass().getMethod("error", String.class, Throwable.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void call(Method method, String msg) {
        try {
            method.invoke(this.logger, msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void info(String msg) {
        this.call(this.info, msg);
    }

    @Override
    public void warn(String msg) {
        this.call(this.warn, msg);
    }

    @Override
    public void debug(String msg) {
        this.call(this.debug, msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        try {
            this.warnExp.invoke(this.logger, msg, t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void error(String msg) {
        this.call(this.error, msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        try {
            this.errorExp.invoke(this.logger, msg, t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

