/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.JdbcUtil;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import java.sql.Connection;

public class IdentityIdGenerator
implements IdGenerator {
    private String table;
    private String column;

    public IdentityIdGenerator(String table, String column) {
        this.table = table;
        this.column = column;
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.IDENTITY;
    }

    @Override
    public String getIdGenName() {
        return "IDENTITY";
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        if (!Boolean.TRUE.equals(dialect.ddlFeatures.getSupportsIdentityColumns())) {
            throw new DialectException("Dialect '" + dialect + "' does not support identity type");
        }
        String sql = null;
        sql = Type.BIGINT.equals((Object)dataType) ? dialect.ddlFeatures.getIdentitySelectStringBigINT() : dialect.ddlFeatures.getIdentitySelectString();
        if (StrUtils.isEmpty(sql) || "NOT_SUPPORT".equals(sql)) {
            throw new DialectException("Dialect '" + dialect + "' does not support identity type");
        }
        sql = StrUtils.replaceFirst(sql, "_table__col", this.table + "_" + this.column);
        return JdbcUtil.qryOneObject(con, sql, new Object[0]);
    }

    @Override
    public IdGenerator newCopy() {
        return new IdentityIdGenerator(this.table, this.column);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }
}

