/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.Type;
import java.util.Map;

public class DialectTypeMappingTemplate {
    protected static void initTypeMappingTemplates() {
        Map<Type, String> m = Dialect.SQLiteDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "blob");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float($p)");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "blob");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "blob");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.AccessDialect.typeMappings;
        m.put(Type.BIGINT, "integer");
        m.put(Type.BINARY, "binary<255|N/A");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "ole");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar($l)");
        m.put(Type.CLOB, "longvarchar");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "java_object");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "timestamp");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary<255|bit varying($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.ExcelDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "longvarchar");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "numeric(5,0)");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "numeric(3,0)");
        m.put(Type.VARBINARY, "varbinary");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.TextDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "java_object");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "numeric(5,0)");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "numeric(3,0)");
        m.put(Type.VARBINARY, "varbinary");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.ParadoxDialect.typeMappings;
        m.put(Type.BIGINT, "integer");
        m.put(Type.BINARY, "binary");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "java_object");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.CobolDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "java_object");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.XMLDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "longvarchar");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "numeric(5,0)");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "numeric(3,0)");
        m.put(Type.VARBINARY, "varbinary");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.DbfDialect.typeMappings;
        m.put(Type.BIGINT, "integer");
        m.put(Type.BINARY, "binary<255|N/A");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "java_object");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary<255|bit varying($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.DamengDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary($l)");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "bit");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "text");
        m.put(Type.LONGVARBINARY, "image");
        m.put(Type.LONGVARCHAR, "text");
        m.put(Type.NCHAR, "char(1)");
        m.put(Type.NCLOB, "clob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "varchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.GBaseDialect.typeMappings;
        m.put(Type.BIGINT, "number(19,0)");
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BIT, "number(1,0)");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "number($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "number(10,0)");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "number($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "number(5,0)");
        m.put(Type.TIME, "date");
        m.put(Type.TIMESTAMP, "date");
        m.put(Type.TINYINT, "number(3,0)");
        m.put(Type.VARBINARY, "raw($l)<2000|long raw");
        m.put(Type.VARCHAR, "varchar2($l)<4000|long");
        m = Dialect.Cache71Dialect.typeMappings;
        m.put(Type.BIGINT, "BigInt");
        m.put(Type.BINARY, "varbinary($1)");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "longvarbinary");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "longvarchar");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "longvarbinary");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.CUBRIDDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "bit(8)");
        m.put(Type.BLOB, "bit varying(65535)");
        m.put(Type.BOOLEAN, "bit(8)");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "string");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "int");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "double");
        m.put(Type.SMALLINT, "short");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "short");
        m.put(Type.VARBINARY, "bit varying($l)<2000|bit varying($l)");
        m.put(Type.VARCHAR, "varchar($l)<255|varchar($l)<2000|string");
        m = Dialect.DataDirectOracle9Dialect.typeMappings;
        m.put(Type.BIGINT, "number(19,0)");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "number(1,0)");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1 char)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "number($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "number(10,0)");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "number($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "number(5,0)");
        m.put(Type.TIME, "date");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "number(3,0)");
        m.put(Type.VARBINARY, "raw($l)<2000|long raw");
        m.put(Type.VARCHAR, "varchar2($l char)<4000|long");
        m = Dialect.DB2Dialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
        m.put(Type.BIT, "smallint");
        m.put(Type.BLOB, "blob($l)");
        m.put(Type.BOOLEAN, "smallint");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "clob($l)");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "long varchar for bit data");
        m.put(Type.LONGVARCHAR, "long varchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "decimal($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "varchar($l) for bit data");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.DB2390Dialect.typeMappings;
        m.putAll(Dialect.DB2Dialect.typeMappings);
        m = Dialect.DB2390V8Dialect.typeMappings;
        m.putAll(Dialect.DB2Dialect.typeMappings);
        m = Dialect.DB2400Dialect.typeMappings;
        m.putAll(Dialect.DB2Dialect.typeMappings);
        m = Dialect.DB297Dialect.typeMappings;
        m.putAll(Dialect.DB2Dialect.typeMappings);
        m = Dialect.DerbyDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
        m.put(Type.BIT, "smallint");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "smallint");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "clob($l)");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "long varchar for bit data");
        m.put(Type.LONGVARCHAR, "long varchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "decimal($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "varchar($l) for bit data");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.DerbyTenFiveDialect.typeMappings;
        m.putAll(Dialect.DerbyDialect.typeMappings);
        m = Dialect.DerbyTenSevenDialect.typeMappings;
        m.putAll(Dialect.DerbyDialect.typeMappings);
        m.put(Type.BOOLEAN, "boolean");
        m = Dialect.DerbyTenSixDialect.typeMappings;
        m.putAll(Dialect.DerbyDialect.typeMappings);
        m = Dialect.FirebirdDialect.typeMappings;
        m.put(Type.BIGINT, "numeric(18,0)");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "smallint");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "smallint");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "blob sub_type 1");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "blob");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.FrontBaseDialect.typeMappings;
        m.put(Type.BIGINT, "longint");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "bit varying($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.H2Dialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "varchar(2147483647)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.HANAColumnStoreDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "varbinary($l)<5000|blob");
        m.put(Type.BIT, "smallint");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "varchar(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p, $s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float($p)");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)<5000|nclob");
        m.put(Type.LONGVARBINARY, "varbinary($l)<5000|blob");
        m.put(Type.LONGVARCHAR, "varchar($l)<5000|clob");
        m.put(Type.NCHAR, "nvarchar(1)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "decimal($p, $s)");
        m.put(Type.NVARCHAR, "nvarchar($l)<5000|nclob");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "varbinary($l)<5000|blob");
        m.put(Type.VARCHAR, "varchar($l)<5000|clob");
        m = Dialect.HANARowStoreDialect.typeMappings;
        m.putAll(Dialect.HANAColumnStoreDialect.typeMappings);
        m = Dialect.HSQLDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary($l)");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "longvarbinary");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char($l)");
        m.put(Type.CLOB, "longvarchar");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "longvarbinary");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "clob");
        m.put(Type.NUMERIC, "numeric");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.InformixDialect.typeMappings;
        m.put(Type.BIGINT, "int8");
        m.put(Type.BINARY, "byte");
        m.put(Type.BIT, "smallint");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal");
        m.put(Type.DOUBLE, "float");
        m.put(Type.FLOAT, "smallfloat");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "blob");
        m.put(Type.LONGVARCHAR, "clob");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "decimal");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "smallfloat");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "datetime hour to second");
        m.put(Type.TIMESTAMP, "datetime year to fraction(5)");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "byte");
        m.put(Type.VARCHAR, "varchar($l)<255|lvarchar($l)<32739|varchar($l)");
        m = Dialect.Informix10Dialect.typeMappings;
        m.putAll(Dialect.InformixDialect.typeMappings);
        m = Dialect.IngresDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "byte($l)<32000|long byte");
        m.put(Type.BIT, "tinyint");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char($l)<32000|char($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p, $s)");
        m.put(Type.DOUBLE, "float");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "long byte");
        m.put(Type.LONGVARCHAR, "long varchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "decimal($p, $s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time with time zone");
        m.put(Type.TIMESTAMP, "timestamp with time zone");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbyte($l)<32000|long byte");
        m.put(Type.VARCHAR, "varchar($l)<32000|long varchar");
        m = Dialect.Ingres10Dialect.typeMappings;
        m.putAll(Dialect.IngresDialect.typeMappings);
        m.put(Type.BIT, "boolean");
        m.put(Type.DATE, "ansidate");
        m.put(Type.TIMESTAMP, "timestamp(9) with time zone");
        m = Dialect.Ingres9Dialect.typeMappings;
        m.putAll(Dialect.IngresDialect.typeMappings);
        m.put(Type.DATE, "ansidate");
        m.put(Type.TIMESTAMP, "timestamp(9) with time zone");
        m = Dialect.InterbaseDialect.typeMappings;
        m.put(Type.BIGINT, "numeric(18,0)");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "smallint");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "smallint");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "blob sub_type 1");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "blob");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.JDataStoreDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "tinyint");
        m.put(Type.BLOB, "varbinary");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "varchar");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p, $s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p, $s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.MariaDBDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "binary($l)");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "longblob");
        m.put(Type.BOOLEAN, "bit");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "longtext");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
        m.put(Type.LONGVARCHAR, "longtext");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "longtext");
        m.put(Type.NUMERIC, "decimal($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m = Dialect.MariaDB53Dialect.typeMappings;
        m.putAll(Dialect.MariaDBDialect.typeMappings);
        m.put(Type.TIMESTAMP, "datetime(6)");
        m = Dialect.MariaDB102Dialect.typeMappings;
        m.putAll(Dialect.MariaDBDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m = Dialect.MariaDB103Dialect.typeMappings;
        m.putAll(Dialect.MariaDBDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m = Dialect.MariaDB10Dialect.typeMappings;
        m.putAll(Dialect.MariaDBDialect.typeMappings);
        m.put(Type.TIMESTAMP, "datetime(6)");
        m = Dialect.MckoiDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.MimerSQLDialect.typeMappings;
        m.put(Type.BIGINT, "BIGINT");
        m.put(Type.BINARY, "BINARY<2000|BLOB($1)");
        m.put(Type.BIT, "ODBC.BIT");
        m.put(Type.BLOB, "BLOB($l)");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "NCHAR(1)");
        m.put(Type.CLOB, "NCLOB($l)");
        m.put(Type.DATE, "DATE");
        m.put(Type.DECIMAL, "NUMERIC(19, $l)");
        m.put(Type.DOUBLE, "DOUBLE PRECISION");
        m.put(Type.FLOAT, "FLOAT");
        m.put(Type.INTEGER, "INTEGER");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "BLOB($1)");
        m.put(Type.LONGVARCHAR, "CLOB($1)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "NUMERIC(19, $l)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "SMALLINT");
        m.put(Type.TIME, "TIME");
        m.put(Type.TIMESTAMP, "TIMESTAMP");
        m.put(Type.TINYINT, "ODBC.TINYINT");
        m.put(Type.VARBINARY, "BINARY VARYING($l)<2000|BLOB($1)");
        m.put(Type.VARCHAR, "NATIONAL CHARACTER VARYING($l)<2000|NCLOB($l)");
        m = Dialect.MySQLDialect.typeMappings;
        m.put(Type.BINARY, "binary($l)");
        m.put(Type.BIT, "bit");
        m.put(Type.LONGBLOB, "longblob");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "bit");
        m.put(Type.CHAR, "char($l)");
        m.put(Type.CLOB, "longtext");
        m.put(Type.DATE, "date");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
        m.put(Type.LONGVARCHAR, "longtext");
        m.put(Type.NCLOB, "longtext");
        m.put(Type.NUMERIC, "decimal($p,$s)");
        m.put(Type.TIME, "time");
        m.put(Type.DATETIME, "datetime");
        m.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.SMALLINT, "smallint($l)");
        m.put(Type.MEDIUMINT, "MEDIUMINT($l)");
        m.put(Type.TINYINT, "tinyint($l)");
        m.put(Type.BIGINT, "bigint($l)");
        m.put(Type.YEAR, "year($l)");
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.INT, "INT($l)");
        m.put(Type.TINYBLOB, "TINYBLOB");
        m.put(Type.TINYTEXT, "TINYTEXT");
        m.put(Type.TEXT, "TEXT($l)");
        m.put(Type.MEDIUMBLOB, "MEDIUMBLOB");
        m.put(Type.MEDIUMTEXT, "MEDIUMTEXT");
        m.put(Type.LONGTEXT, "LONGTEXT");
        m.put(Type.JSON, "JSON");
        m = Dialect.MySQL5Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m = Dialect.MySQL55Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m = Dialect.MySQL57Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m = Dialect.MySQL57InnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m = Dialect.MySQL5InnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m = Dialect.MySQLInnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m = Dialect.MySQLMyISAMDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m = Dialect.MySQL8Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m.put(Type.VARCHAR, "varchar($l)<65535|longtext");
        m = Dialect.OracleDialect.typeMappings;
        m.put(Type.BIGINT, "number(19,0)");
        m.put(Type.BIT, "number(1,0)");
        m.put(Type.BLOB, "blob");
        m.put(Type.CHAR, "char($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "number($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "number($l,0)");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "number($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "number(5,0)");
        m.put(Type.TIME, "date");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "number(3,0)");
        m.put(Type.VARBINARY, "raw($l)<2000|long raw");
        m.put(Type.BINARY_FLOAT, "BINARY_FLOAT");
        m.put(Type.BINARY_DOUBLE, "BINARY_DOUBLE");
        m.put(Type.DOUBLE_PRECISION, "DOUBLE PRECISION");
        m.put(Type.TIMESTAMP_WITH_TIME_ZONE, "TIMESTAMP WITH TIME ZONE");
        m.put(Type.TIMESTAMP_WITH_LOCAL_TIME_ZONE, "TIMESTAMP WITH LOCAL TIME ZONE");
        m.put(Type.INTERVAL_YEAR_TO_MONTH, "INTERVAL YEAR($l) TO MONTH");
        m.put(Type.INTERVAL_DAY_TO_SECOND, "INTERVAL DAY($p) TO SECOND($s)");
        m.put(Type.VARCHAR2, "varchar2($l)");
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.VARCHAR, "varchar($l char)<4000|long");
        m = Dialect.Oracle10gDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.NVARCHAR, "nvarchar2($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.Oracle12cDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.NVARCHAR, "nvarchar2($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.Oracle8iDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m = Dialect.Oracle9Dialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.Oracle9iDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.NVARCHAR, "nvarchar2($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.PointbaseDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "smallint");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "blob($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.PostgreSQLDialect.typeMappings;
        m.put(Type.BIGINT, "int8");
        m.put(Type.BINARY, "bytea");
        m.put(Type.BIT, "bool");
        m.put(Type.BLOB, "oid");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "text");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p, $s)");
        m.put(Type.DOUBLE, "float8");
        m.put(Type.FLOAT, "float4");
        m.put(Type.INTEGER, "int4");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bytea");
        m.put(Type.LONGVARCHAR, "text");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p, $s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "int2");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "int2");
        m.put(Type.VARBINARY, "bytea");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.PostgresPlusDialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL81Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL82Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL9Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL91Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL92Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.PostgreSQL93Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.PostgreSQL94Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.PostgreSQL95Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.ProgressDialect.typeMappings;
        m.put(Type.BIGINT, "numeric");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "character(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "real");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "varbinary($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.RDMSOS2200Dialect.typeMappings;
        m.put(Type.BIGINT, "NUMERIC(21,0)");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "SMALLINT");
        m.put(Type.BLOB, "BLOB($l)");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "CHARACTER(1)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "DATE");
        m.put(Type.DECIMAL, "NUMERIC(21,$l)");
        m.put(Type.DOUBLE, "DOUBLE PRECISION");
        m.put(Type.FLOAT, "FLOAT");
        m.put(Type.INTEGER, "INTEGER");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "NUMERIC(21,$l)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "REAL");
        m.put(Type.SMALLINT, "SMALLINT");
        m.put(Type.TIME, "TIME");
        m.put(Type.TIMESTAMP, "TIMESTAMP");
        m.put(Type.TINYINT, "SMALLINT");
        m.put(Type.VARBINARY, "bit varying($l)");
        m.put(Type.VARCHAR, "CHARACTER($l)");
        m = Dialect.SAPDBDialect.typeMappings;
        m.put(Type.BIGINT, "fixed(19,0)");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "long byte");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "long varchar");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "fixed($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "int");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "fixed($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "fixed(3,0)");
        m.put(Type.VARBINARY, "long byte");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.SQLServerDialect.typeMappings;
        m.put(Type.BIGINT, "numeric(19,0)");
        m.put(Type.BINARY, "binary($l)");
        m.put(Type.BIT, "tinyint");
        m.put(Type.BLOB, "image");
        m.put(Type.BOOLEAN, "bit");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "text");
        m.put(Type.DATE, "datetime");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "int");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "image");
        m.put(Type.LONGVARCHAR, "text");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "datetime");
        m.put(Type.TIMESTAMP, "datetime");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "varbinary($l)<8000|image");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.SQLServer2005Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "varbinary(MAX)");
        m.put(Type.CLOB, "varchar(MAX)");
        m.put(Type.LONGVARBINARY, "varbinary(MAX)");
        m.put(Type.LONGVARCHAR, "varchar(MAX)");
        m.put(Type.NCLOB, "nvarchar(MAX)");
        m.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
        m = Dialect.SQLServer2008Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "varbinary(MAX)");
        m.put(Type.CLOB, "varchar(MAX)");
        m.put(Type.DATE, "date");
        m.put(Type.LONGVARBINARY, "varbinary(MAX)");
        m.put(Type.LONGVARCHAR, "varchar(MAX)");
        m.put(Type.NCLOB, "nvarchar(MAX)");
        m.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime2");
        m.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
        m = Dialect.SQLServer2012Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "varbinary(MAX)");
        m.put(Type.CLOB, "varchar(MAX)");
        m.put(Type.DATE, "date");
        m.put(Type.LONGVARBINARY, "varbinary(MAX)");
        m.put(Type.LONGVARCHAR, "varchar(MAX)");
        m.put(Type.NCLOB, "nvarchar(MAX)");
        m.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime2");
        m.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
        m = Dialect.SybaseDialect.typeMappings;
        m.put(Type.BIGINT, "numeric(19,0)");
        m.put(Type.BINARY, "binary($l)");
        m.put(Type.BIT, "tinyint");
        m.put(Type.BLOB, "image");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "text");
        m.put(Type.DATE, "datetime");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "int");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "datetime");
        m.put(Type.TIMESTAMP, "datetime");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "varbinary($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.Sybase11Dialect.typeMappings;
        m.putAll(Dialect.SybaseDialect.typeMappings);
        m = Dialect.SybaseAnywhereDialect.typeMappings;
        m.putAll(Dialect.SybaseDialect.typeMappings);
        m.put(Type.BOOLEAN, "bit");
        m = Dialect.SybaseASE15Dialect.typeMappings;
        m.putAll(Dialect.SybaseDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BOOLEAN, "tinyint");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.LONGVARBINARY, "image");
        m.put(Type.LONGVARCHAR, "text");
        m.put(Type.TIME, "time");
        m = Dialect.SybaseASE157Dialect.typeMappings;
        m.putAll(Dialect.SybaseDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BOOLEAN, "tinyint");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.LONGVARBINARY, "image");
        m.put(Type.LONGVARCHAR, "text");
        m.put(Type.TIME, "time");
        m = Dialect.TeradataDialect.typeMappings;
        m.put(Type.BIGINT, "NUMERIC(18,0)");
        m.put(Type.BINARY, "BYTEINT");
        m.put(Type.BIT, "BYTEINT");
        m.put(Type.BLOB, "BLOB");
        m.put(Type.BOOLEAN, "BYTEINT");
        m.put(Type.CHAR, "CHAR(1)");
        m.put(Type.CLOB, "CLOB");
        m.put(Type.DATE, "DATE");
        m.put(Type.DECIMAL, "DECIMAL");
        m.put(Type.DOUBLE, "DOUBLE PRECISION");
        m.put(Type.FLOAT, "FLOAT");
        m.put(Type.INTEGER, "INTEGER");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "LONG VARCHAR");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "NUMERIC($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "SMALLINT");
        m.put(Type.TIME, "TIME");
        m.put(Type.TIMESTAMP, "TIMESTAMP");
        m.put(Type.TINYINT, "BYTEINT");
        m.put(Type.VARBINARY, "VARBYTE($l)");
        m.put(Type.VARCHAR, "VARCHAR($l)");
        m = Dialect.Teradata14Dialect.typeMappings;
        m.putAll(Dialect.TeradataDialect.typeMappings);
        m.put(Type.BIGINT, "BIGINT");
        m.put(Type.BINARY, "VARBYTE(100)");
        m.put(Type.LONGVARBINARY, "VARBYTE(32000)");
        m.put(Type.LONGVARCHAR, "VARCHAR(32000)");
        m = Dialect.TimesTenDialect.typeMappings;
        m.put(Type.BIGINT, "BIGINT");
        m.put(Type.BINARY, "N/A");
        m.put(Type.BIT, "TINYINT");
        m.put(Type.BLOB, "VARBINARY(4000000)");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "CHAR(1)");
        m.put(Type.CLOB, "VARCHAR(4000000)");
        m.put(Type.DATE, "DATE");
        m.put(Type.DECIMAL, "DECIMAL($p, $s)");
        m.put(Type.DOUBLE, "DOUBLE");
        m.put(Type.FLOAT, "FLOAT");
        m.put(Type.INTEGER, "INTEGER");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bit varying($l)");
        m.put(Type.LONGVARCHAR, "varchar($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "DECIMAL($p, $s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "SMALLINT");
        m.put(Type.TIME, "TIME");
        m.put(Type.TIMESTAMP, "TIMESTAMP");
        m.put(Type.TINYINT, "TINYINT");
        m.put(Type.VARBINARY, "VARBINARY($l)");
        m.put(Type.VARCHAR, "VARCHAR($l)");
    }
}

