/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public abstract class Java8DateUtils {
    private static final ZoneId zoneId = ZoneId.systemDefault();

    public static LocalDate date2LocalDate(Date date) {
        Instant instant = new Date(date.getTime()).toInstant();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static Date localDate2Date(LocalDate localDate) {
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return new Date(Date.from(zdt.toInstant()).getTime());
    }

    public static java.sql.Date localDate2SqlDate(LocalDate localDate) {
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        return new java.sql.Date(Date.from(zdt.toInstant()).getTime());
    }

    public static Time localTime2SqlTime(LocalTime localTime) {
        return Time.valueOf(localTime);
    }

    public static Time offsetTime2SqlTime(OffsetTime offsetTime) {
        return Time.valueOf(offsetTime.toLocalTime());
    }

    public static Timestamp instant2SqlTimestamp(Instant instant) {
        return new Timestamp(Date.from(instant).getTime());
    }

    public static Timestamp localDateTime2SqlTimestamp(LocalDateTime localDateTime) {
        return Timestamp.valueOf(localDateTime);
    }

    public static Timestamp offsetDateTime2SqlTimestamp(OffsetDateTime offsetDateTime) {
        return Timestamp.valueOf(offsetDateTime.toLocalDateTime());
    }

    public static Timestamp zonedDateTime2SqlTimestamp(ZonedDateTime zonedDateTime) {
        return Timestamp.valueOf(zonedDateTime.toLocalDateTime());
    }

    public static LocalDate sqlDate2localDate(java.sql.Date date) {
        Instant instant = new Date(date.getTime()).toInstant();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static LocalDateTime sqlDate2localDateTime(java.sql.Date date) {
        Instant instant = new Date(date.getTime()).toInstant();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static LocalTime sqlTime2LocalTime(Time time) {
        return time.toLocalTime();
    }

    public static LocalDateTime sqlTime2LocalDateTime(Time time) {
        Instant instant = new Date(time.getTime()).toInstant();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static OffsetTime sqlTime2OffsetTime(Time time) {
        Instant instant = new Date(time.getTime()).toInstant();
        return OffsetTime.ofInstant(instant, zoneId);
    }

    public static OffsetTime sqlTimestamp2OffsetTime(Timestamp t) {
        return OffsetTime.ofInstant(t.toInstant(), zoneId);
    }

    public static Instant sqlTimestamp2instant(Timestamp t) {
        return t.toInstant();
    }

    public static LocalDateTime sqlTimestamp2LocalDateTime(Timestamp t) {
        return t.toLocalDateTime();
    }

    public static OffsetDateTime sqlTimestamp2OffsetDateTime(Timestamp t) {
        return OffsetDateTime.ofInstant(t.toInstant(), zoneId);
    }

    public static ZonedDateTime sqlTimestamp2ZonedDateTime(Timestamp t) {
        return ZonedDateTime.ofInstant(t.toInstant(), zoneId);
    }

    public static LocalDate sqlTimestamp2LocalDate(Timestamp t) {
        Instant instant = new Date(t.getTime()).toInstant();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static LocalTime sqlTimestamp2LocalTime(Timestamp t) {
        Instant instant = new Date(t.getTime()).toInstant();
        return instant.atZone(zoneId).toLocalTime();
    }
}

