/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class DebugUtils {
    public static String getColumnModelDebugInfo(ColumnModel c) {
        StringBuilder sb = new StringBuilder();
        sb.append("columnName=" + c.getColumnName()).append(", ");
        sb.append("transient=" + c.getTransientable()).append(", ");
        sb.append("columnType=" + (Object)((Object)c.getColumnType())).append(", ");
        sb.append("pkey=" + c.getPkey()).append(", ");
        if (c.getShardTable() != null) {
            sb.append("shardTable=" + Arrays.deepToString(c.getShardTable())).append(", ");
        } else {
            sb.append("shardTable=null").append(", ");
        }
        if (c.getShardDatabase() != null) {
            sb.append("shardDatabase=" + Arrays.deepToString(c.getShardDatabase())).append(", ");
        } else {
            sb.append("shardDatabase=null").append(", ");
        }
        sb.append("idGenerationType=" + (Object)((Object)c.getIdGenerationType())).append(", ");
        sb.append("idGeneratorName=" + c.getIdGeneratorName()).append(", ");
        sb.append("idGenerator=" + c.getIdGenerator()).append(", ");
        sb.append("converterClassOrName=" + c.getConverterClassOrName()).append(", ");
        sb.append("entityField=" + c.getEntityField()).append(", ");
        sb.append("length=" + c.getLength()).append(", ");
        sb.append("precisio=" + c.getPrecision()).append(", ");
        sb.append("scale" + c.getScale()).append(", ");
        sb.append("valueExist=" + c.getValueExist()).append(", ");
        sb.append("value=" + c.getValue()).append(", ");
        return sb.toString();
    }

    public static String getFkeyDebugInfo(TableModel t) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fkeys:\r\n");
        for (FKeyModel k : t.getFkeyConstraints()) {
            sb.append("FkeyName=" + k.getFkeyName());
            sb.append(", ColumnNames=" + k.getColumnNames());
            sb.append(", RefTableAndColumns=" + Arrays.deepToString(k.getRefTableAndColumns()));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelDebugInfo(TableModel model) {
        StringBuilder sb = new StringBuilder("\r\n=======================================================\r\n");
        sb.append("tableName=" + model.getTableName()).append("\r\n");
        sb.append("getEntityClass=" + model.getEntityClass()).append("\r\n");
        sb.append("readOnly=" + model.getReadOnly()).append("\r\n");
        sb.append(DebugUtils.getFkeyDebugInfo(model));
        List<ColumnModel> columns = model.getColumns();
        sb.append("Columns:\r\n");
        for (ColumnModel column : columns) {
            sb.append(DebugUtils.getColumnModelDebugInfo(column)).append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelsDebugInfo(TableModel[] models) {
        StringBuilder sb = new StringBuilder();
        for (TableModel model : models) {
            sb.append(DebugUtils.getTableModelDebugInfo(model));
        }
        return sb.toString();
    }

    public static String getDialectFullInfo(Dialect d) {
        String s = "\r\n\r\n=======Dialect Debug Info======\r\n";
        String r = "\r\n";
        DDLFeatures l = d.ddlFeatures;
        s = s + "name=" + d.getName() + r;
        s = s + "===== Dialect pagination templates =====" + r;
        s = s + "sqlTemplate=" + d.sqlTemplate + r;
        s = s + "topLimitTemplate=" + d.topLimitTemplate + r;
        s = s + "===== Dialect DDL feature templates =====" + r;
        s = s + "addColumnString=" + l.addColumnString + r;
        s = s + "addColumnSuffixString=" + l.addColumnSuffixString + r;
        s = s + "addForeignKeyConstraintString=" + l.addForeignKeyConstraintString + r;
        s = s + "addFKeyRefPkeyString=" + l.addFKeyRefPkeyString + r;
        s = s + "addPrimaryKeyConstraintString=" + l.addPrimaryKeyConstraintString + r;
        s = s + "columnComment=" + l.columnComment + r;
        s = s + "createCatalogCommand=" + l.createCatalogCommand + r;
        s = s + "createMultisetTableString=" + l.createMultisetTableString + r;
        s = s + "createPooledSequenceStrings=" + l.createPooledSequenceStrings + r;
        s = s + "createSchemaCommand=" + l.createSchemaCommand + r;
        s = s + "createSequenceStrings=" + l.createSequenceStrings + r;
        s = s + "createTableString=" + l.createTableString + r;
        s = s + "currentSchemaCommand=" + l.currentSchemaCommand + r;
        s = s + "dropCatalogCommand=" + l.dropCatalogCommand + r;
        s = s + "dropForeignKeyString=" + l.dropForeignKeyString + r;
        s = s + "dropSchemaCommand=" + l.dropSchemaCommand + r;
        s = s + "dropSequenceStrings=" + l.dropSequenceStrings + r;
        s = s + "dropTableString=" + l.dropTableString + r;
        s = s + "hasAlterTable=" + l.hasAlterTable + r;
        s = s + "hasDataTypeInIdentityColumn=" + l.hasDataTypeInIdentityColumn + r;
        s = s + "identityColumnString=" + l.identityColumnString + r;
        s = s + "identityColumnStringBigINT=" + l.identityColumnStringBigINT + r;
        s = s + "identitySelectString=" + l.identitySelectString + r;
        s = s + "identitySelectStringBigINT=" + l.identitySelectStringBigINT + r;
        s = s + "needDropConstraintsBeforeDropTable=" + l.needDropConstraintsBeforeDropTable + r;
        s = s + "nullColumnString=" + l.nullColumnString + r;
        s = s + "requiresParensForTupleDistinctCounts=" + l.requiresParensForTupleDistinctCounts + r;
        s = s + "selectSequenceNextValString=" + l.selectSequenceNextValString + r;
        s = s + "sequenceNextValString=" + l.sequenceNextValString + r;
        s = s + "supportsColumnCheck=" + l.supportsColumnCheck + r;
        s = s + "supportsCommentOn=" + l.supportsCommentOn + r;
        s = s + "supportsIdentityColumns=" + l.supportsIdentityColumns + r;
        s = s + "supportsIfExistsAfterConstraintName=" + l.supportsIfExistsAfterConstraintName + r;
        s = s + "===== Dialect type mapping templates =====" + r;
        Map<Type, String> t = d.typeMappings;
        for (Type p : t.keySet()) {
            s = s + (Object)((Object)p) + "=" + t.get((Object)p) + r;
        }
        s = s + "===== Dialect function templates =====" + r;
        Map<String, String> f = d.functions;
        for (String fn : f.keySet()) {
            s = s + fn + "=" + f.get(fn) + r;
        }
        s = s + "======================================";
        return s;
    }
}

