/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.file.nio.validation;

import com.crabshue.commons.exceptions.ValidationException;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.file.nio.exceptions.FileErrorContext;
import com.crabshue.commons.file.nio.exceptions.FileErrorType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileValidationUtils {
    public static void validateFolder(Path folderPath) {
        if (!Files.isDirectory(folderPath, new LinkOption[0])) {
            throw new ValidationException((ErrorType)FileErrorType.NOT_A_FOLDER).addContextValue((ErrorContext)FileErrorContext.FOLDER, (Object)folderPath);
        }
    }

    public static void validateFile(Path filePath) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new ValidationException((ErrorType)FileErrorType.NOT_A_FILE).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)filePath);
        }
    }
}

