/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.file.nio;

import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.file.nio.FileSystemUtils;
import com.crabshue.commons.file.nio.exceptions.FileErrorContext;
import com.crabshue.commons.file.nio.exceptions.FileErrorType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import org.apache.commons.lang3.Validate;

public class FileIOUtils {
    public static Path writeFile(byte[] bytes, Path outputFilePath) {
        Validate.notNull((Object)bytes);
        Validate.notNull((Object)outputFilePath);
        try {
            FileSystemUtils.retrieveOrCreateFile(outputFilePath);
            Files.write(outputFilePath, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_WRITING_FILE, "cannot write file", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)outputFilePath);
        }
        return outputFilePath;
    }

    public static Collection<String> readLines(Path filePath) {
        Validate.notNull((Object)filePath);
        try {
            return Files.readAllLines(filePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_READING_FILE, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)filePath);
        }
    }
}

